/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight999.t_and_t.config.r;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import de.cristelknight999.t_and_t.TT;
import de.cristelknight999.t_and_t.config.r.Array2;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLConfig;

public class ConfigUtil {
    public static final Path CONFIG_DIR = Path.of(FMLConfig.defaultConfigPath().replace("defaultconfigs", "config"), new String[0]);
    public static final Path CONFIG_T_AND_T = Path.of(CONFIG_DIR.toString(), "/towns_and_towers");
    public static final Path RES_T_AND_T = CONFIG_T_AND_T.resolve("resources/");
    public static final Jankson JANKSON = Jankson.builder().build();
    public static final Supplier<JsonGrammar.Builder> JSON_GRAMMAR_BUILDER = () -> new JsonGrammar.Builder().withComments(true).bareSpecialNumerics(true).printCommas(true);
    public static final JsonGrammar JSON_GRAMMAR = JSON_GRAMMAR_BUILDER.get().build();
    public static final String MODID_UP = "t_and_t".toUpperCase();

    public static <T> T readConfig(Path path, Codec<T> codec, DynamicOps<JsonElement> ops) {
        try {
            JsonObject load = JANKSON.load(path.toFile());
            DataResult decode = codec.decode(ops, (Object)load);
            Optional error = decode.error();
            if (error.isPresent()) {
                throw new IllegalArgumentException("[" + MODID_UP + "] Couldn't read config " + path + ", crashing instead Maybe try to delete the config files!");
            }
            return (T)((Pair)decode.result().orElseThrow()).getFirst();
        }
        catch (Exception errorMsg) {
            throw new IllegalArgumentException("[" + MODID_UP + "] Couldn't read config " + path + ", crashing instead Maybe try to delete the config files!");
        }
    }

    public static <T> void createConfig(Path path, Codec<T> codec, String header, Map<String, String> comments, DynamicOps<JsonElement> ops, T from) {
        DataResult dataResult = codec.encodeStart(ops, from);
        Optional error = dataResult.error();
        if (error.isPresent()) {
            throw new IllegalArgumentException(String.format("[" + MODID_UP + "] Jankson file creation for \"%s\" failed due to the following error(s):\n%s", path.toString(), ((DataResult.PartialResult)error.get()).message()));
        }
        JsonElement jsonElement = (JsonElement)dataResult.result().orElseThrow();
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonElement = ConfigUtil.addCommentsAndAlphabeticallySortRecursively(comments, (JsonElement)jsonObject, "", false);
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String output = header + "\n" + jsonElement.toJson(JSON_GRAMMAR);
            Files.write(path, output.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            TT.LOGGER.error(e.toString());
        }
    }

    public static JsonElement addCommentsAndAlphabeticallySortRecursively(Map<String, String> comments, JsonElement element, String parentKey, boolean alphabeticallySorted) {
        if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            return ConfigUtil.handleArray(comments, alphabeticallySorted, parentKey, jsonArray);
        }
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            for (Map.Entry entry2 : object.entrySet()) {
                JsonElement value;
                String objectKey = (String)entry2.getKey();
                String commentsKey = parentKey + objectKey;
                String comment = object.getComment((String)entry2.getKey());
                if (comments.containsKey(commentsKey) && comment == null) {
                    String commentToAdd = comments.get(commentsKey);
                    object.setComment(objectKey, commentToAdd);
                    comment = commentToAdd;
                }
                if ((value = (JsonElement)entry2.getValue()) instanceof JsonArray) {
                    JsonArray array = (JsonArray)value;
                    JsonArray jsonElements = ConfigUtil.handleArray(comments, alphabeticallySorted, (String)entry2.getKey(), array);
                    if (!jsonElements.isEmpty()) {
                        object.put(objectKey, (JsonElement)jsonElements, comment);
                    }
                }
                if (!(value instanceof JsonObject)) continue;
                JsonObject nestedObject = (JsonObject)value;
                object.put(objectKey, ConfigUtil.addCommentsAndAlphabeticallySortRecursively(comments, (JsonElement)nestedObject, (String)entry2.getKey() + ".", alphabeticallySorted), comment);
            }
            if (alphabeticallySorted) {
                JsonObject alphabeticallySortedJsonObject = new JsonObject();
                TreeMap map = new TreeMap(String::compareTo);
                map.putAll(object);
                alphabeticallySortedJsonObject.putAll(map);
                alphabeticallySortedJsonObject.forEach((key, entry) -> alphabeticallySortedJsonObject.setComment(key, object.getComment(key)));
                return alphabeticallySortedJsonObject;
            }
            return object;
        }
        if (element instanceof JsonPrimitive) {
            return element;
        }
        throw new IllegalArgumentException("[" + MODID_UP + "] Unknown Jankson JsonElementType.");
    }

    private static JsonArray handleArray(Map<String, String> comments, boolean alphabeticallySorted, String objectKey, JsonArray array) {
        JsonArray sortedJsonElements = new JsonArray();
        for (JsonElement element1 : array) {
            if (element1 instanceof JsonObject) {
                JsonObject nestedObject = (JsonObject)element1;
                sortedJsonElements.add(ConfigUtil.addCommentsAndAlphabeticallySortRecursively(comments, (JsonElement)nestedObject, objectKey + ".", alphabeticallySorted));
                continue;
            }
            if (!(element1 instanceof JsonArray)) continue;
            JsonArray array1 = (JsonArray)element1;
            Array2 arrayOfArrays = new Array2();
            arrayOfArrays.addAll((Collection)array1);
            sortedJsonElements.add((JsonElement)arrayOfArrays);
        }
        return sortedJsonElements;
    }
}

