/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensuraiaf.handler;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.manasmods.tensura.event.EnergyDrainEvent;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.event.SpiritualHurtEvent;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensuraiaf.TensuraIafConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensuraiaf", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IafDropHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDragonDeath(LivingDeathEvent e) {
        if (e.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof EntityDragonBase)) {
            return;
        }
        EntityDragonBase dragon = (EntityDragonBase)livingEntity;
        if (dragon.f_19853_.m_5776_()) {
            return;
        }
        if (!dragon.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            return;
        }
        if (dragon.getDragonStage() < (Integer)TensuraIafConfig.INSTANCE.minDragonStageForEssence.get()) {
            return;
        }
        if (dragon.getDragonStage() > (Integer)TensuraIafConfig.INSTANCE.maxDragonStageForEssence.get()) {
            return;
        }
        dragon.m_19998_((ItemLike)TensuraMobDropItems.DRAGON_ESSENCE.get());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEnergyDrain(EnergyDrainEvent e) {
        if (e.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof EntityDragonBase)) {
            return;
        }
        EntityDragonBase dragon = (EntityDragonBase)livingEntity;
        if (dragon.isModelDead() || dragon.getDeathStage() > 0) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSkillPlunder(SkillPlunderEvent e) {
        if (e.isCanceled()) {
            return;
        }
        Entity entity = e.getTarget();
        if (!(entity instanceof EntityDragonBase)) {
            return;
        }
        EntityDragonBase dragon = (EntityDragonBase)entity;
        if (dragon.isModelDead() || dragon.getDeathStage() > 0) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSpiritualHurt(SpiritualHurtEvent e) {
        if (e.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof EntityDragonBase)) {
            return;
        }
        EntityDragonBase dragon = (EntityDragonBase)livingEntity;
        if (dragon.isModelDead() || dragon.getDeathStage() > 0) {
            e.setCanceled(true);
        }
    }
}

