/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensuraiaf.ability;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensuraiaf.registry.IafEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class IceBreathSkill
extends Skill {
    public IceBreathSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return new ResourceLocation("tensuraiaf", "textures/temp_textures/item/confused_rimuru.png");
        }
        return new ResourceLocation("tensuraiaf", "textures/skill/" + this.getType().getNamespace() + "/" + id.m_135815_().replace('/', '.') + ".png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        instance.getOrCreateTag().m_128405_("BreathEntity", 0);
        instance.markDirty();
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        BreathEntity.spawnBreathEntity((EntityType)((EntityType)IafEntityTypes.ICE_BREATH.get()), (LivingEntity)entity, (ManasSkillInstance)instance, (double)this.magiculeCost(entity, instance));
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144205_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

