/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensuraiaf.ability;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraIndirectEntityDamageSource;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.github.manasmods.tensuraiaf.registry.IafEntityTypes;
import com.github.manasmods.tensuraiaf.registry.IafParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class IceBreathProjectile
extends BreathEntity {
    public IceBreathProjectile(EntityType<? extends IceBreathProjectile> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public IceBreathProjectile(Level level, LivingEntity entity) {
        this((EntityType<? extends IceBreathProjectile>)((EntityType)IafEntityTypes.ICE_BREATH.get()), level);
        this.m_5602_((Entity)entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.placeIce();
            this.clearFluid();
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        DamageSource damageSource;
        Entity entity = entityHitResult.m_82443_();
        if (entity.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost((DamageSource)(damageSource = new TensuraIndirectEntityDamageSource("ice_breath", (Entity)this, this.m_37282_()).setNoKnock().setNotTensuraMagic().m_19389_()), (double)this.getMpCost(), (ManasSkillInstance)this.getSkill()), 8.0f) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            FrozenProperties.setFrozenFor((LivingEntity)living, (int)50);
        }
    }

    public void placeIce() {
        if (this.m_37282_() == null) {
            return;
        }
        if (!TensuraGameRules.canSkillGrief((Level)this.m_9236_())) {
            return;
        }
        float range = 0.2617994f;
        for (int i = 0; i < 3; ++i) {
            SkillGriefEvent.Pre preGrief;
            Vec3 cast = this.m_37282_().m_20154_().m_82541_().m_82496_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range).m_82524_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range);
            BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(this.m_37282_().m_146892_(), this.m_37282_().m_146892_().m_82549_(cast.m_82490_((double)this.getLength())), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
            Vec3 pos = hitResult.m_82450_().m_82546_(cast.m_82490_(0.5));
            BlockPos blockPos = new BlockPos(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            if (!this.m_9236_().m_8055_(blockPos).m_60795_() || !this.m_9236_().m_8055_(blockPos.m_7495_()).m_60767_().m_76333_() || MinecraftForge.EVENT_BUS.post((Event)(preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), blockPos)))) continue;
            this.m_9236_().m_46597_(blockPos, ((Block)IafBlockRegistry.DRAGON_ICE_SPIKES.get()).m_49966_());
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), blockPos));
        }
    }

    public void clearFluid() {
        if (this.m_37282_() == null) {
            return;
        }
        if (!TensuraGameRules.canSkillGrief((Level)this.m_9236_())) {
            return;
        }
        float range = 0.2617994f;
        for (int i = 0; i < 3; ++i) {
            SkillGriefEvent.Pre preGrief;
            Vec3 cast = this.m_37282_().m_20154_().m_82541_().m_82496_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range).m_82524_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range);
            BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(this.m_37282_().m_146892_(), this.m_37282_().m_146892_().m_82549_(cast.m_82490_((double)this.getLength())), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this));
            if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
            BlockPos blockPos = hitResult.m_82425_();
            if (this.m_9236_().m_8055_(blockPos).m_204336_(BlockTags.f_13076_)) {
                preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), blockPos);
                if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) continue;
                this.m_9236_().m_7471_(blockPos, false);
                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), blockPos));
                continue;
            }
            if (this.m_9236_().m_8055_(blockPos).m_60713_(Blocks.f_49991_)) {
                preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), blockPos);
                if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) continue;
                this.m_9236_().m_46597_(blockPos, this.m_9236_().m_6425_(blockPos).m_76170_() ? Blocks.f_50080_.m_49966_() : Blocks.f_50652_.m_49966_());
                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), blockPos));
                continue;
            }
            if (this.m_9236_().m_8055_(blockPos).m_60713_(Blocks.f_49990_) && this.m_9236_().m_6425_(blockPos).m_76170_()) {
                preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), blockPos);
                if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) continue;
                this.m_9236_().m_46597_(blockPos, Blocks.f_50449_.m_49966_());
                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), blockPos));
                continue;
            }
            if (!this.m_9236_().m_8055_(blockPos).m_60713_((Block)TensuraBlocks.HOT_SPRING_WATER.get()) || !this.m_9236_().m_6425_(blockPos).m_76170_() || MinecraftForge.EVENT_BUS.post((Event)(preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), blockPos)))) continue;
            this.m_9236_().m_46597_(blockPos, Blocks.f_50568_.m_49966_());
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), blockPos));
        }
    }

    public void spawnParticle() {
        Entity entity = this.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        Vec3 rotation = owner.m_20154_().m_82541_();
        Vec3 pos = owner.m_20182_().m_82549_(rotation.m_82490_(1.6));
        double x = pos.f_82479_;
        double y = pos.f_82480_ + (double)(owner.m_20192_() * 0.9f);
        double z = pos.f_82481_;
        double speed = owner.m_217043_().m_188500_() * 0.35 + 0.35;
        for (int i = 0; i < 10; ++i) {
            double ox = Math.random() * 0.3 - 0.15;
            double oy = Math.random() * 0.3 - 0.15;
            double oz = Math.random() * 0.3 - 0.15;
            Vec3 randomVec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_();
            Vec3 result = rotation.m_82490_(3.0).m_82549_(randomVec).m_82541_().m_82490_(speed);
            owner.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, x + ox, y + oy, z + oz, result.f_82479_, result.f_82480_, result.f_82481_);
            owner.m_9236_().m_7106_((ParticleOptions)IafParticles.SNOWFLAKE_EFFECT.get(), x + ox, y + oy, z + oz, result.f_82479_, result.f_82480_, result.f_82481_);
        }
    }
}

