/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensuraiaf;

import com.github.manasmods.tensuraiaf.TensuraIafConfig;
import com.github.manasmods.tensuraiaf.data.gen.IafBlockTagProvider;
import com.github.manasmods.tensuraiaf.data.gen.IafEntityEPProvider;
import com.github.manasmods.tensuraiaf.data.gen.IafEntityTypeTagProvider;
import com.github.manasmods.tensuraiaf.data.gen.IafGearEpProvider;
import com.github.manasmods.tensuraiaf.data.gen.IafItemTagProvider;
import com.github.manasmods.tensuraiaf.data.gen.IafLanguageProvider;
import com.github.manasmods.tensuraiaf.registry.IafRegistry;
import java.nio.file.Path;
import net.minecraft.data.DataProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tensuraiaf")
public class TensuraIaF {
    public static final String MOD_ID = "tensuraiaf";
    public static final String CONFIG_DIR = "tensura-reincarnated";
    private static final Logger LOGGER = LogManager.getLogger();

    public TensuraIaF() {
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve(CONFIG_DIR), (String)CONFIG_DIR);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TensuraIafConfig.SPEC, this.getConfigFileName("iaf_common"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IafRegistry.register(modEventBus);
        modEventBus.addListener(this::generateData);
    }

    private void generateData(GatherDataEvent event) {
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new IafEntityEPProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new IafEntityTypeTagProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new IafLanguageProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new IafGearEpProvider(event));
        IafBlockTagProvider provider = new IafBlockTagProvider(event);
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)provider);
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new IafItemTagProvider(event, provider));
    }

    private String getConfigFileName(String name) {
        return String.format("%s/%s.toml", CONFIG_DIR, name);
    }

    public static Logger getLOGGER() {
        return LOGGER;
    }
}

