/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsTabBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.Tab;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class SettingsTabControl<C extends AbstractContainerScreen<?>, T extends SettingsTabBase<C>>
extends CompositeWidgetBase<Tab> {
    private static final int VERTICAL_SPACE = 1;
    @Nullable
    private T openTab = null;

    protected SettingsTabControl(Position position) {
        super(position, new Dimension(0, 0));
    }

    protected <U extends T> U addSettingsTab(Runnable onTabOpenContainerAction, Runnable onTabCloseContainerAction, U tab) {
        SettingsTabBase settingsTab = (SettingsTabBase)((Object)this.addChild(tab));
        settingsTab.setHandlers(() -> {
            if (this.openTab != null && this.differentTabIsOpen(settingsTab)) {
                ((SettingsTabBase)((Object)((Object)this.openTab))).close();
            }
            this.openTab = settingsTab;
            onTabOpenContainerAction.run();
        }, () -> {
            if (this.openTab != null) {
                this.openTab = null;
                onTabCloseContainerAction.run();
            }
        }, () -> this.openTab == null || !this.differentTabIsOpen(settingsTab) || this.isNotCovered(this.openTab, settingsTab, true), () -> this.openTab == null || this.isNotCovered(this.openTab, settingsTab, false));
        return (U)((Object)settingsTab);
    }

    @Override
    protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, -11.0);
        this.children.forEach(child -> {
            if (child != this.openTab) {
                child.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
        });
        matrixStack.m_85849_();
        if (this.openTab != null) {
            ((Tab)((Object)this.openTab)).m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        RenderSystem.m_69482_();
    }

    private boolean isNotCovered(T open, Tab t, boolean checkFullyCovered) {
        if (checkFullyCovered) {
            return ((Tab)((Object)open)).getBottomY() < t.getBottomY() || ((Tab)((Object)open)).getTopY() > t.getTopY();
        }
        return ((Tab)((Object)open)).getBottomY() < t.getTopY() || ((Tab)((Object)open)).getTopY() > t.getTopY();
    }

    private boolean differentTabIsOpen(Tab tab) {
        return this.openTab != tab;
    }

    public Optional<T> getOpenTab() {
        return Optional.ofNullable(this.openTab);
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
    }

    @Override
    public void renderTooltip(Screen screen, PoseStack poseStack, int mouseX, int mouseY) {
        this.children.forEach(tab -> tab.renderTooltip(screen, poseStack, mouseX, mouseY));
    }

    protected int getTopY() {
        return this.y + this.children.size() * 25;
    }

    @Override
    public int getHeight() {
        MutableInt maxY = new MutableInt(0);
        this.children.forEach(tab -> {
            int bottomY = tab.getBottomY();
            if (bottomY > maxY.getValue()) {
                maxY.setValue(bottomY);
            }
        });
        return maxY.getValue() - this.y;
    }

    @Override
    public int getWidth() {
        MutableInt maxWidth = new MutableInt(0);
        this.children.forEach(tab -> {
            int width = tab.getWidth();
            if (width > maxWidth.getValue()) {
                maxWidth.setValue(width);
            }
        });
        return maxWidth.getValue();
    }

    public List<Rect2i> getTabRectangles() {
        ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
        this.children.forEach(child -> child.getRectangle().ifPresent(ret::add));
        return ret;
    }

    @Override
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

