/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::stitchTextures);
        modBus.addListener(ModParticles::registerFactories);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onPlayerJoinServer);
        eventBus.addListener(StorageSoundHandler::tick);
        eventBus.addListener(StorageSoundHandler::onWorldUnload);
        eventBus.addListener(ClientEventHandler::onDrawScreen);
    }

    public static void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            evt.addSprite(StorageContainerMenuBase.EMPTY_UPGRADE_SLOT_BACKGROUND);
            evt.addSprite((ResourceLocation)StorageContainerMenuBase.INACCESSIBLE_SLOT_BACKGROUND.getSecond());
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_INPUT_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_OUTPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_INPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_OUTPUT_SLOT_BACKGROUND);
        }
    }

    private static void onDrawScreen(ScreenEvent.Render.Post event) {
        AbstractContainerScreen containerGui;
        Minecraft mc;
        block7: {
            block6: {
                mc = Minecraft.m_91087_();
                Screen gui = mc.f_91080_;
                if (!(gui instanceof AbstractContainerScreen)) break block6;
                containerGui = (AbstractContainerScreen)gui;
                if (!(gui instanceof CreativeModeInventoryScreen) && mc.f_91074_ != null) break block7;
            }
            return;
        }
        AbstractContainerMenu menu = containerGui.m_6262_();
        ItemStack held = menu.m_142621_();
        if (!held.m_41619_()) {
            Slot under = containerGui.getSlotUnderMouse();
            PoseStack poseStack = event.getPoseStack();
            for (Slot s : menu.f_38839_) {
                Optional<StashResultAndTooltip> stashResultAndTooltip;
                ItemStack stack = s.m_7993_();
                if (!s.m_8010_((Player)mc.f_91074_) || stack.m_41619_() || (stashResultAndTooltip = ClientEventHandler.getStashResultAndTooltip(stack, held)).isEmpty()) continue;
                if (s == under) {
                    ClientEventHandler.renderSpecialTooltip(event, mc, containerGui, poseStack, stashResultAndTooltip.get());
                    continue;
                }
                ClientEventHandler.renderStashSign(mc, containerGui, poseStack, s, stack, stashResultAndTooltip.get().stashResult());
            }
        }
    }

    private static void renderStashSign(Minecraft mc, AbstractContainerScreen<?> containerGui, PoseStack poseStack, Slot s, ItemStack stack, IStashStorageItem.StashResult stashResult) {
        int color;
        int x = containerGui.getGuiLeft() + s.f_40220_;
        int y = containerGui.getGuiTop() + s.f_40221_;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 300.0);
        int n = color = stashResult == IStashStorageItem.StashResult.MATCH_AND_SPACE ? ChatFormatting.GREEN.m_126665_() : 0xFFFF00;
        if (stack.m_41720_() instanceof IStashStorageItem) {
            mc.f_91062_.m_92750_(poseStack, "+", (float)x + 10.0f, (float)y + 8.0f, color);
        } else {
            mc.f_91062_.m_92750_(poseStack, "-", (float)(x + 1), (float)y, color);
        }
        poseStack.m_85849_();
    }

    private static void renderSpecialTooltip(ScreenEvent.Render.Post event, Minecraft mc, AbstractContainerScreen<?> containerGui, PoseStack poseStack, StashResultAndTooltip stashResultAndTooltip) {
        int x = event.getMouseX();
        int y = event.getMouseY();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 100.0);
        containerGui.renderTooltip(poseStack, Collections.singletonList(Component.m_237115_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), stashResultAndTooltip.tooltip(), x, y, mc.f_91062_);
        poseStack.m_85849_();
    }

    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(ItemStack inInventory, ItemStack held) {
        Item item;
        if (inInventory.m_41613_() == 1 && (item = inInventory.m_41720_()) instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResultAndTooltip(inInventory, held, stashStorageItem);
        }
        item = held.m_41720_();
        if (item instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResultAndTooltip(held, inInventory, stashStorageItem);
        }
        return Optional.empty();
    }

    @NotNull
    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(ItemStack potentialStashStorage, ItemStack potentiallyStashable, IStashStorageItem stashStorageItem) {
        IStashStorageItem.StashResult stashResult = stashStorageItem.getItemStashable(potentialStashStorage, potentiallyStashable);
        if (stashResult == IStashStorageItem.StashResult.NO_SPACE) {
            return Optional.empty();
        }
        return Optional.of(new StashResultAndTooltip(stashResult, stashStorageItem.getInventoryTooltip(potentialStashStorage)));
    }

    private static void onPlayerJoinServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        RecipeHelper.setWorld((Level)Minecraft.m_91087_().f_91073_);
    }

    private record StashResultAndTooltip(IStashStorageItem.StashResult stashResult, Optional<TooltipComponent> tooltip) {
    }
}

