/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen.processor;

import com.github.alexthe666.iceandfire.block.BlockDreadBase;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafProcessors;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DreadRuinProcessor
extends StructureProcessor {
    public static final DreadRuinProcessor INSTANCE = new DreadRuinProcessor();
    public static final Codec<DreadRuinProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public static BlockState getRandomCrackedBlock(@Nullable BlockState prev, RandomSource random) {
        float rand = random.m_188501_();
        if ((double)rand < 0.5) {
            return ((BlockDreadBase)IafBlockRegistry.DREAD_STONE_BRICKS.get()).m_49966_();
        }
        if ((double)rand < 0.9) {
            return ((BlockDreadBase)IafBlockRegistry.DREAD_STONE_BRICKS_CRACKED.get()).m_49966_();
        }
        return ((BlockDreadBase)IafBlockRegistry.DREAD_STONE_BRICKS_MOSSY.get()).m_49966_();
    }

    public StructureTemplate.StructureBlockInfo process(@NotNull LevelReader worldReader, @NotNull BlockPos pos, @NotNull BlockPos pos2, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        RandomSource random = settings.m_230326_(infoIn2.f_74675_);
        if (infoIn2.f_74676_.m_60734_() == IafBlockRegistry.DREAD_STONE_BRICKS.get()) {
            BlockState state = DreadRuinProcessor.getRandomCrackedBlock(null, random);
            return new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_, state, null);
        }
        if (infoIn2.f_74676_.m_60734_() == IafBlockRegistry.DREAD_SPAWNER.get()) {
            CompoundTag tag = new CompoundTag();
            CompoundTag spawnData = new CompoundTag();
            ResourceLocation spawnerMobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.getRandomMobForMobSpawner(random));
            if (spawnerMobId != null) {
                CompoundTag entity = new CompoundTag();
                entity.m_128359_("id", spawnerMobId.toString());
                spawnData.m_128365_("entity", (Tag)entity);
                tag.m_128473_("SpawnPotentials");
                tag.m_128365_("SpawnData", (Tag)spawnData.m_6426_());
            }
            StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_, ((Block)IafBlockRegistry.DREAD_SPAWNER.get()).m_49966_(), tag);
            return newInfo;
        }
        return infoIn2;
    }

    @NotNull
    protected StructureProcessorType m_6953_() {
        return (StructureProcessorType)IafProcessors.DREADRUINPROCESSOR.get();
    }

    private EntityType getRandomMobForMobSpawner(RandomSource random) {
        float rand = random.m_188501_();
        if ((double)rand < 0.3) {
            return (EntityType)IafEntityRegistry.DREAD_THRALL.get();
        }
        if ((double)rand < 0.5) {
            return (EntityType)IafEntityRegistry.DREAD_GHOUL.get();
        }
        if ((double)rand < 0.7) {
            return (EntityType)IafEntityRegistry.DREAD_BEAST.get();
        }
        if ((double)rand < 0.85) {
            return (EntityType)IafEntityRegistry.DREAD_SCUTTLER.get();
        }
        return (EntityType)IafEntityRegistry.DREAD_KNIGHT.get();
    }
}

