/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.datagen.IafProcessorLists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class IafStructurePieces {
    public static final ResourceKey<StructureTemplatePool> GRAVEYARD_START = IafStructurePieces.createKey("graveyard/start_pool");
    public static final ResourceKey<StructureTemplatePool> MAUSOLEUM_START = IafStructurePieces.createKey("mausoleum/start_pool");
    public static final ResourceKey<StructureTemplatePool> GORGON_TEMPLE_START = IafStructurePieces.createKey("gorgon_temple/start_pool");

    private static ResourceKey<StructureTemplatePool> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122884_, (ResourceLocation)new ResourceLocation("iceandfire", name));
    }

    public static Map<ResourceLocation, StructureTemplatePool> gather(RegistryOps<JsonElement> registryOps) {
        Holder fallback = ((Registry)registryOps.m_206826_(Registry.f_122884_).get()).m_214121_(Pools.f_127186_);
        Holder graveyardProcessors = ((Registry)registryOps.m_206826_(Registry.f_122883_).get()).m_214121_(IafProcessorLists.GRAVEYARD_PROCESSORS);
        StructureTemplatePool graveyardStartPool = new StructureTemplatePool(GRAVEYARD_START.m_135782_(), ((StructureTemplatePool)fallback.m_203334_()).m_210587_(), List.of(Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:graveyard/graveyard_top", (Holder)graveyardProcessors), (Object)1)), StructureTemplatePool.Projection.RIGID);
        ResourceLocation graveyardBottom = IafStructurePieces.createKey("graveyard/bottom_pool").m_135782_();
        StructureTemplatePool graveyardBottomPool = new StructureTemplatePool(graveyardBottom, ((StructureTemplatePool)fallback.m_203334_()).m_210587_(), List.of(Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:graveyard/graveyard_bottom", (Holder)graveyardProcessors), (Object)1)), StructureTemplatePool.Projection.RIGID);
        Holder mausoleumProcessors = ((Registry)registryOps.m_206826_(Registry.f_122883_).get()).m_214121_(IafProcessorLists.MAUSOLEUM_PROCESSORS);
        StructureTemplatePool mausoleumStartPool = new StructureTemplatePool(MAUSOLEUM_START.m_135782_(), ((StructureTemplatePool)fallback.m_203334_()).m_210587_(), List.of(Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:mausoleum/building", (Holder)mausoleumProcessors), (Object)1)), StructureTemplatePool.Projection.RIGID);
        Holder gorgonTempleProcessors = ((Registry)registryOps.m_206826_(Registry.f_122883_).get()).m_214121_(IafProcessorLists.GORGON_TEMPLE_PROCESSORS);
        StructureTemplatePool gorgonTempleStartPool = new StructureTemplatePool(GORGON_TEMPLE_START.m_135782_(), ((StructureTemplatePool)fallback.m_203334_()).m_210587_(), List.of(Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:gorgon_temple/building", (Holder)gorgonTempleProcessors), (Object)1)), StructureTemplatePool.Projection.RIGID);
        ResourceLocation gorgonTempleBottom = IafStructurePieces.createKey("gorgon_temple/bottom_pool").m_135782_();
        StructureTemplatePool gorgonTempleBottomPool = new StructureTemplatePool(gorgonTempleBottom, ((StructureTemplatePool)fallback.m_203334_()).m_210587_(), List.of(Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:gorgon_temple/basement", (Holder)gorgonTempleProcessors), (Object)1)), StructureTemplatePool.Projection.RIGID);
        ResourceLocation gorgonTempleGorgon = IafStructurePieces.createKey("gorgon_temple/gorgon_pool").m_135782_();
        StructureTemplatePool gorgonTempleGorgonPool = new StructureTemplatePool(gorgonTempleGorgon, ((StructureTemplatePool)fallback.m_203334_()).m_210587_(), List.of(Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:gorgon_temple/gorgon", (Holder)gorgonTempleProcessors), (Object)1)), StructureTemplatePool.Projection.RIGID);
        return Map.of(GRAVEYARD_START.m_135782_(), graveyardStartPool, graveyardBottom, graveyardBottomPool, MAUSOLEUM_START.m_135782_(), mausoleumStartPool, GORGON_TEMPLE_START.m_135782_(), gorgonTempleStartPool, gorgonTempleBottom, gorgonTempleBottomPool, gorgonTempleGorgon, gorgonTempleGorgonPool);
    }
}

