/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour;

import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface ValueSettingsBehaviour
extends ClipboardCloneable {
    public boolean testHit(Vec3 var1);

    public boolean isActive();

    default public boolean onlyVisibleWithWrench() {
        return false;
    }

    default public void newSettingHovered(ValueSettings valueSetting) {
    }

    public ValueBoxTransform getSlotPositioning();

    public ValueSettingsBoard createBoard(Player var1, BlockHitResult var2);

    public void setValueSettings(Player var1, ValueSettings var2, boolean var3);

    public ValueSettings getValueSettings();

    default public boolean acceptsValueSettings() {
        return true;
    }

    @Override
    default public String getClipboardKey() {
        return "Settings";
    }

    @Override
    default public boolean writeToClipboard(CompoundTag tag, Direction side) {
        if (!this.acceptsValueSettings()) {
            return false;
        }
        ValueSettings valueSettings = this.getValueSettings();
        tag.m_128405_("Value", valueSettings.value());
        tag.m_128405_("Row", valueSettings.row());
        return true;
    }

    @Override
    default public boolean readFromClipboard(CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (!this.acceptsValueSettings()) {
            return false;
        }
        if (!tag.m_128441_("Value") || !tag.m_128441_("Row")) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.setValueSettings(player, new ValueSettings(tag.m_128451_("Row"), tag.m_128451_("Value")), false);
        return true;
    }

    default public void playFeedbackSound(BlockEntityBehaviour origin) {
        origin.getWorld().m_5594_(null, origin.getPos(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 2.0f);
        origin.getWorld().m_5594_(null, origin.getPos(), SoundEvents.f_12167_, SoundSource.BLOCKS, 0.03f, 1.125f);
    }

    default public void onShortInteract(Player player, InteractionHand hand, Direction side) {
    }

    public record ValueSettings(int row, int value) {
        public MutableComponent format() {
            return Lang.number(this.value).component();
        }
    }
}

