/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.PlaceExtendedCurvePacket;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackPlacement;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TrackBlockItem
extends BlockItem {
    public TrackBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        SoundType soundtype;
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        if (player == null) {
            return super.m_6225_(pContext);
        }
        if (pContext.m_43724_() == InteractionHand.OFF_HAND) {
            return super.m_6225_(pContext);
        }
        Vec3 lookAngle = player.m_20154_();
        if (!this.m_5812_(stack)) {
            TrackBlockEntity tbe;
            TrackBlock track;
            Block block = state.m_60734_();
            if (block instanceof TrackBlock && (track = (TrackBlock)block).getTrackAxes((BlockGetter)level, pos, state).size() > 1) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)Lang.translateDirect("track.junction_start", new Object[0]).m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.SUCCESS;
            }
            block = level.m_7702_(pos);
            if (block instanceof TrackBlockEntity && (tbe = (TrackBlockEntity)block).isTilted()) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)Lang.translateDirect("track.turn_start", new Object[0]).m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (TrackBlockItem.select((LevelAccessor)level, pos, lookAngle, stack)) {
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return super.m_6225_(pContext);
        }
        if (player.m_6144_()) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Lang.translateDirect("track.selection_cleared", new Object[0]), true);
                stack.m_41751_(null);
            } else {
                level.m_5594_(player, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.75f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        boolean placing = !(state.m_60734_() instanceof ITrackBlock);
        CompoundTag tag = stack.m_41783_();
        boolean extend = tag.m_128471_("ExtendCurve");
        tag.m_128473_("ExtendCurve");
        if (placing) {
            if (!state.m_60767_().m_76336_()) {
                pos = pos.m_121945_(pContext.m_43719_());
            }
            if ((state = this.getPlacementState(pContext)) == null) {
                return InteractionResult.FAIL;
            }
        }
        ItemStack offhandItem = player.m_21206_();
        boolean hasGirder = AllBlocks.METAL_GIRDER.isIn(offhandItem);
        TrackPlacement.PlacementInfo info = TrackPlacement.tryConnect(level, player, pos, state, stack, hasGirder, extend);
        if (info.message != null && !level.f_46443_) {
            player.m_5661_((Component)Lang.translateDirect(info.message, new Object[0]), true);
        }
        if (!info.valid) {
            AllSoundEvents.DENY.playFrom((Entity)player, 1.0f, 1.0f);
            return InteractionResult.FAIL;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        stack = player.m_21205_();
        if (AllTags.AllBlockTags.TRACKS.matches(stack)) {
            stack.m_41751_(null);
            player.m_21008_(pContext.m_43724_(), stack);
        }
        if ((soundtype = state.m_60827_()) != null) {
            level.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState getPlacementState(UseOnContext pContext) {
        return this.m_5965_(this.m_7732_(new BlockPlaceContext(pContext)));
    }

    public static boolean select(LevelAccessor world, BlockPos pos, Vec3 lookVec, ItemStack heldItem) {
        ITrackBlock track;
        Pair<Vec3, Direction.AxisDirection> nearestTrackAxis;
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return false;
        }
        Vec3 axis = nearestTrackAxis.getFirst().m_82490_((nearestTrackAxis = (track = (ITrackBlock)block).getNearestTrackAxis((BlockGetter)world, pos, blockState, lookVec)).getSecond() == Direction.AxisDirection.POSITIVE ? -1.0 : 1.0);
        Vec3 end = track.getCurveStart((BlockGetter)world, pos, blockState, axis);
        Vec3 normal = track.getUpNormal((BlockGetter)world, pos, blockState).m_82541_();
        CompoundTag compoundTag = heldItem.m_41698_("ConnectingFrom");
        compoundTag.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        compoundTag.m_128365_("Axis", (Tag)VecHelper.writeNBT(axis));
        compoundTag.m_128365_("Normal", (Tag)VecHelper.writeNBT(normal));
        compoundTag.m_128365_("End", (Tag)VecHelper.writeNBT(end));
        return true;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void sendExtenderPacket(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!AllTags.AllBlockTags.TRACKS.matches(stack) || !stack.m_41782_()) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92091_.m_90857_()) {
            AllPackets.getChannel().sendToServer((Object)new PlaceExtendedCurvePacket(event.getHand() == InteractionHand.MAIN_HAND, true));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("ConnectingFrom");
    }
}

