/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;

public class ToolboxBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IBE<ToolboxBlockEntity> {
    protected final DyeColor color;

    public ToolboxBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> p_149666_2_) {
        if (group != CreativeModeTab.f_40754_ && this.color != DyeColor.BROWN) {
            return;
        }
        super.m_49811_(group, p_149666_2_);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{BlockStateProperties.f_61362_}).m_61104_(new Property[]{f_54117_}));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            CompoundTag orCreateTag = stack.m_41784_();
            be.readInventory(orCreateTag.m_128469_("Inventory"));
            if (orCreateTag.m_128441_("UniqueId")) {
                be.setUniqueId(orCreateTag.m_128342_("UniqueId"));
            }
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
        });
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moving) {
        if (!(!state.m_155947_() || newState.m_155947_() && newState.m_60734_() instanceof ToolboxBlock)) {
            world.m_46747_(pos);
        }
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, ToolboxBlockEntity::unequipTracked);
        if (world instanceof ServerLevel) {
            ItemStack cloneItemStack = this.m_7397_((BlockGetter)world, pos, state);
            world.m_46961_(pos, false);
            if (world.m_8055_(pos) != state) {
                player.m_150109_().m_150079_(cloneItemStack);
            }
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack item = new ItemStack((ItemLike)this);
        Optional blockEntityOptional = this.getBlockEntityOptional(world, pos);
        CompoundTag tag = item.m_41784_();
        CompoundTag inv = blockEntityOptional.map(tb -> tb.inventory.serializeNBT()).orElse(new CompoundTag());
        tag.m_128365_("Inventory", (Tag)inv);
        blockEntityOptional.map(tb -> tb.getUniqueId()).ifPresent(uid -> tag.m_128362_("UniqueId", uid));
        blockEntityOptional.map(ToolboxBlockEntity::m_7770_).ifPresent(arg_0 -> ((ItemStack)item).m_41714_(arg_0));
        return item;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return AllShapes.TOOLBOX.get((Direction)state.m_61143_((Property)f_54117_));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player == null || player.m_6047_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null && color != this.color) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties(state, AllBlocks.TOOLBOXES.get(color).getDefaultState());
            world.m_46597_(pos, newState);
            return InteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, toolbox -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)toolbox, toolbox::sendToMenu));
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Override
    public Class<ToolboxBlockEntity> getBlockEntityClass() {
        return ToolboxBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ToolboxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.TOOLBOX.get();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static Ingredient getMainBox() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AllBlocks.TOOLBOXES.get(DyeColor.BROWN).get()});
    }
}

