/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.harvester;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlockEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HarvesterRenderer
extends SafeBlockEntityRenderer<HarvesterBlockEntity> {
    private static final Vec3 PIVOT = new Vec3(0.0, 6.0, 9.0);

    public HarvesterRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(HarvesterBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        SuperByteBuffer superBuffer = CachedBufferer.partial(AllPartialModels.HARVESTER_BLADE, blockState);
        HarvesterRenderer.transform(be.m_58904_(), (Direction)blockState.m_61143_((Property)HarvesterBlock.f_54117_), superBuffer, be.getAnimatedSpeed(), PIVOT);
        superBuffer.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffers) {
        float speed;
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        SuperByteBuffer superBuffer = CachedBufferer.partial(AllPartialModels.HARVESTER_BLADE, blockState);
        float f = speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.m_122424_()) ? context.getAnimationSpeed() : 0.0f;
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        superBuffer.transform(matrices.getModel());
        HarvesterRenderer.transform(context.world, facing, superBuffer, speed, PIVOT);
        superBuffer.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffers.m_6299_(RenderType.m_110457_()));
    }

    public static void transform(Level world, Direction facing, SuperByteBuffer superBuffer, float speed, Vec3 pivot) {
        float originOffset = 0.0625f;
        Vec3 rotOffset = new Vec3(0.0, pivot.f_82480_ * (double)originOffset, pivot.f_82481_ * (double)originOffset);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)world) / 20.0f;
        float angle = time * speed % 360.0f;
        ((SuperByteBuffer)superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing))).translate(rotOffset.f_82479_, rotOffset.f_82480_, rotOffset.f_82481_).rotate(Direction.WEST, AngleHelper.rad(angle))).translate(-rotOffset.f_82479_, -rotOffset.f_82480_, -rotOffset.f_82481_);
    }
}

