/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;

public class CommandCarryOn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"carryon").then(Commands.m_82127_((String)"debug").executes(cmd -> CommandCarryOn.handleDebug((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"clear").executes(cmd -> CommandCarryOn.handleClear((CommandSourceStack)cmd.getSource(), Collections.singleton(((CommandSourceStack)cmd.getSource()).m_81375_()))))).then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).requires(src -> src.m_6761_(2))).executes(cmd -> CommandCarryOn.handleClear((CommandSourceStack)cmd.getSource(), EntityArgument.m_91477_((CommandContext)cmd, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"place").requires(src -> src.m_6761_(2))).executes(cmd -> CommandCarryOn.handlePlace((CommandSourceStack)cmd.getSource(), Collections.singleton(((CommandSourceStack)cmd.getSource()).m_81375_()))))).then(Commands.m_82127_((String)"place").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).requires(src -> src.m_6761_(2))).executes(cmd -> CommandCarryOn.handlePlace((CommandSourceStack)cmd.getSource(), EntityArgument.m_91477_((CommandContext)cmd, (String)"target")))));
        dispatcher.register(builder);
    }

    private static int handleDebug(CommandSourceStack source) {
        try {
            if (source.m_81374_() != null) {
                ServerPlayer player = source.m_81375_();
                CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
                if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                    Optional<PickupCondition> cond;
                    BlockState block = carry.getBlock();
                    CommandCarryOn.log(source, "Block: " + block.m_60734_());
                    CommandCarryOn.log(source, "BlockState: " + block);
                    CommandCarryOn.log(source, "NBT: " + carry.getNbt());
                    Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(block, carry.getContentNbt());
                    if (ov.isPresent()) {
                        CommandCarryOn.log(source, "Override Model: " + ov.get().getRenderObject());
                    }
                    if ((cond = PickupConditionHandler.getPickupCondition(block)).isPresent()) {
                        CommandCarryOn.log(source, "Custom Pickup Condition: " + cond.get().getCondition());
                    }
                    return 1;
                }
                if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                    Entity entity = carry.getEntity(player.f_19853_);
                    CommandCarryOn.log(source, "Entity: " + entity);
                    CommandCarryOn.log(source, "Entity Name: " + entity.m_6095_());
                    CommandCarryOn.log(source, "NBT: " + carry.getNbt());
                    Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(entity);
                    if (cond.isPresent()) {
                        CommandCarryOn.log(source, "Custom Pickup Condition: " + cond.get().getCondition());
                    }
                    return 1;
                }
                if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
                    CommandCarryOn.log(source, "Carrying Player.");
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return 0;
    }

    private static int handleClear(CommandSourceStack source, Collection<ServerPlayer> players) {
        int cleared = 0;
        for (ServerPlayer player : players) {
            CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
            carry.clear();
            CarryOnDataManager.setCarryData((Player)player, carry);
            ++cleared;
        }
        if (cleared != 1) {
            source.m_81354_((Component)Component.m_237113_((String)("Cleared " + cleared + " Items!")), true);
        } else {
            source.m_81354_((Component)Component.m_237113_((String)("Cleared " + cleared + " Item!")), true);
        }
        return 1;
    }

    private static int handlePlace(CommandSourceStack source, Collection<ServerPlayer> players) {
        int cleared = 0;
        for (ServerPlayer player : players) {
            PlacementHandler.placeCarried(player);
            ++cleared;
        }
        if (cleared != 1) {
            source.m_81354_((Component)Component.m_237113_((String)("Placed " + cleared + " Items!")), true);
        } else {
            source.m_81354_((Component)Component.m_237113_((String)("Placed " + cleared + " Item!")), true);
        }
        return 1;
    }

    private static void log(CommandSourceStack source, String toLog) {
        source.m_81354_((Component)Component.m_237113_((String)toLog), true);
        Constants.LOG.info(toLog);
    }
}

