/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.world;

import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TensuraGameRules {
    public static GameRules.Key<GameRules.IntegerValue> MAX_AP;
    public static GameRules.Key<GameRules.IntegerValue> MAX_MP;
    public static GameRules.Key<GameRules.IntegerValue> MIN_EP;
    public static GameRules.Key<GameRules.IntegerValue> DEMON_LORD_SEED;
    public static GameRules.Key<GameRules.IntegerValue> DEMON_LORD_AWAKEN;
    public static GameRules.Key<GameRules.BooleanValue> LABYRINTH_PVP;
    public static GameRules.Key<GameRules.BooleanValue> LABYRINTH_DEATH;
    public static GameRules.Key<GameRules.BooleanValue> COLOSSUS_RESPAWN;
    public static GameRules.Key<GameRules.IntegerValue> EP_DEATH_PENALTY;
    public static GameRules.Key<GameRules.IntegerValue> MP_SKILL_COST;
    public static GameRules.Key<GameRules.BooleanValue> NO_UNIQUE_START;
    public static GameRules.Key<GameRules.BooleanValue> TRULY_UNIQUE;
    public static GameRules.Key<GameRules.IntegerValue> RESET_INCOMPLETE_PENALTY;
    public static GameRules.Key<GameRules.IntegerValue> RESET_COUNTER_BONUS_UNIQUE;
    public static GameRules.Key<GameRules.BooleanValue> SKILL_BEFORE_RACE;
    public static GameRules.Key<GameRules.BooleanValue> HARDCORE_RACE;
    public static GameRules.Key<GameRules.BooleanValue> SKILL_GRIEFING;
    public static GameRules.Key<GameRules.BooleanValue> SKILL_STEAL;
    public static GameRules.Key<GameRules.BooleanValue> EP_STEAL;
    public static GameRules.Key<GameRules.BooleanValue> MIND_CONTROL;
    public static GameRules.Key<GameRules.BooleanValue> PLAYER_NAME;
    public static GameRules.Key<GameRules.BooleanValue> TENSURA_DISPLAY_NAME;
    public static GameRules.Key<GameRules.BooleanValue> RIMURU_MODE;
    public static GameRules.Key<GameRules.IntegerValue> MAX_MP_GAIN;
    public static GameRules.Key<GameRules.IntegerValue> MAX_AP_GAIN;
    public static GameRules.Key<GameRules.IntegerValue> EP_GAIN;
    public static GameRules.Key<GameRules.IntegerValue> PLAYER_EP;
    public static GameRules.Key<GameRules.IntegerValue> VANILLA_EP;
    public static GameRules.Key<GameRules.IntegerValue> SPAWNER_EP;
    public static GameRules.Key<GameRules.BooleanValue> EXPERIMENTAL_FEATURE;

    public static void registryGameRules() {
        MAX_AP = GameRules.m_46189_((String)"maxAP", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)1000000000));
        MAX_MP = GameRules.m_46189_((String)"maxMP", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)1000000000));
        MIN_EP = GameRules.m_46189_((String)"minEP", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)100));
        LABYRINTH_PVP = GameRules.m_46189_((String)"labyrinthPvp", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
        LABYRINTH_DEATH = GameRules.m_46189_((String)"labyrinthDeath", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        COLOSSUS_RESPAWN = GameRules.m_46189_((String)"colossusRespawn", (GameRules.Category)GameRules.Category.SPAWNING, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        EP_DEATH_PENALTY = GameRules.m_46189_((String)"epDeathPenalty", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)5));
        MP_SKILL_COST = GameRules.m_46189_((String)"mpSkillCost", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)100));
        PLAYER_NAME = GameRules.m_46189_((String)"playerNaming", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
        SKILL_GRIEFING = GameRules.m_46189_((String)"skillGriefing", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
        SKILL_STEAL = GameRules.m_46189_((String)"skillSteal", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
        EP_STEAL = GameRules.m_46189_((String)"epSteal", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        MIND_CONTROL = GameRules.m_46189_((String)"playerMindControl", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
        MAX_MP_GAIN = GameRules.m_46189_((String)"maxMpGain", (GameRules.Category)GameRules.Category.DROPS, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)1000000000));
        MAX_AP_GAIN = GameRules.m_46189_((String)"maxApGain", (GameRules.Category)GameRules.Category.DROPS, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)1000000000));
        EP_GAIN = GameRules.m_46189_((String)"epGain", (GameRules.Category)GameRules.Category.DROPS, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)3));
        PLAYER_EP = GameRules.m_46189_((String)"playerEP", (GameRules.Category)GameRules.Category.DROPS, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)100));
        VANILLA_EP = GameRules.m_46189_((String)"vanillaEP", (GameRules.Category)GameRules.Category.DROPS, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)100));
        SPAWNER_EP = GameRules.m_46189_((String)"spawnerEP", (GameRules.Category)GameRules.Category.DROPS, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)10));
        DEMON_LORD_SEED = GameRules.m_46189_((String)"demonLordSeed", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)200000));
        DEMON_LORD_AWAKEN = GameRules.m_46189_((String)"demonLordAwaken", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)10000));
        RIMURU_MODE = GameRules.m_46189_((String)"rimuruMode", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        NO_UNIQUE_START = GameRules.m_46189_((String)"noUniqueStart", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        TRULY_UNIQUE = GameRules.m_46189_((String)"trulyUnique", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        RESET_COUNTER_BONUS_UNIQUE = GameRules.m_46189_((String)"resetCounterBonusUnique", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)0));
        RESET_INCOMPLETE_PENALTY = GameRules.m_46189_((String)"resetIncompletePenalty", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)0));
        SKILL_BEFORE_RACE = GameRules.m_46189_((String)"skillBeforeRace", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        HARDCORE_RACE = GameRules.m_46189_((String)"hardcoreRace", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        TENSURA_DISPLAY_NAME = GameRules.m_46189_((String)"tensuraDisplayName", (GameRules.Category)GameRules.Category.CHAT, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        EXPERIMENTAL_FEATURE = GameRules.m_46189_((String)"experimentalFeature", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    }

    public static int getMinEp(Level level) {
        return level.m_46469_().m_46215_(MIN_EP);
    }

    public static float getEPGain(Level level) {
        return (float)level.m_46469_().m_46215_(EP_GAIN) / 100.0f;
    }

    public static boolean canStealSkill(Level level) {
        return level.m_46469_().m_46207_(SKILL_STEAL);
    }

    public static boolean canEpSteal(Level level) {
        return level.m_46469_().m_46207_(EP_STEAL);
    }

    public static boolean noPlayerMindControl(Level level) {
        return !level.m_46469_().m_46207_(MIND_CONTROL);
    }

    public static boolean canSkillGrief(Level level) {
        if (level.m_46472_().equals(TensuraDimensions.LABYRINTH)) {
            return false;
        }
        return level.m_46469_().m_46207_(SKILL_GRIEFING);
    }

    public static boolean isLabyrinthPvpOff(Level level) {
        if (!level.m_46472_().equals(TensuraDimensions.LABYRINTH)) {
            return false;
        }
        return !level.m_46469_().m_46207_(LABYRINTH_PVP);
    }

    public static boolean isLabyrinthPvpOff(Level level, Entity target, @Nullable Entity attacker) {
        TensuraHorseEntity horse;
        TamableAnimal animal;
        if (!TensuraGameRules.isLabyrinthPvpOff(level)) {
            return false;
        }
        if (attacker == target) {
            return false;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (player.m_7500_()) {
                return false;
            }
            if (target instanceof Player) {
                return true;
            }
            return target instanceof CloneEntity;
        }
        if (attacker instanceof TamableAnimal && (animal = (TamableAnimal)attacker).m_21824_()) {
            TamableAnimal entity;
            if (target instanceof Player) {
                return true;
            }
            return target instanceof TamableAnimal && (entity = (TamableAnimal)target).m_21824_();
        }
        if (attacker instanceof TensuraHorseEntity && (horse = (TensuraHorseEntity)attacker).m_30614_()) {
            TensuraHorseEntity entity;
            if (target instanceof Player) {
                return true;
            }
            return target instanceof TensuraHorseEntity && (entity = (TensuraHorseEntity)target).m_30614_();
        }
        return false;
    }
}

