/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public interface ITensuraScrollbar {
    public static final ResourceLocation SCROLL_BAR = new ResourceLocation("tensura", "textures/gui/scroll_bar.png");
    public static final ScrollbarData SCROLLBAR_DATA = new ScrollbarData();
    public static final int SB_WIDTH = 10;
    public static final int SB_HEIGHT = 13;
    public static final int SB_TEXTURE_HEIGHT = 26;

    public int getStartIndex();

    public int getOffscreenRows();

    public void setStartIndex(int var1);

    default public void initScrollbar(int posX, int posY, int totalSpace, float offset, boolean isScrolling, boolean isActive) {
        ITensuraScrollbar.SCROLLBAR_DATA.scrollbarX = posX;
        ITensuraScrollbar.SCROLLBAR_DATA.scrollbarY = posY;
        ITensuraScrollbar.SCROLLBAR_DATA.scrollbarSpace = totalSpace;
        ITensuraScrollbar.SCROLLBAR_DATA.scrollbarOffset = offset;
        ITensuraScrollbar.SCROLLBAR_DATA.isScrolling = isScrolling;
        ITensuraScrollbar.SCROLLBAR_DATA.isActive = isActive;
    }

    default public void renderScrollbar(PoseStack poseStack) {
        int k = (int)((float)(ITensuraScrollbar.SCROLLBAR_DATA.scrollbarSpace - 13) * ITensuraScrollbar.SCROLLBAR_DATA.scrollbarOffset);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCROLL_BAR);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)ITensuraScrollbar.SCROLLBAR_DATA.scrollbarX, (int)(ITensuraScrollbar.SCROLLBAR_DATA.scrollbarY + k), (float)0.0f, (float)(ITensuraScrollbar.SCROLLBAR_DATA.isActive ? 13.0f : 0.0f), (int)10, (int)13, (int)10, (int)26);
    }

    default public void handleScrollbarMouseClicked(double mouseX, double mouseY) {
        int pX = ITensuraScrollbar.SCROLLBAR_DATA.scrollbarX;
        int pY = ITensuraScrollbar.SCROLLBAR_DATA.scrollbarY;
        SCROLLBAR_DATA.setScrolling(mouseX > (double)pX && mouseX < (double)(pX + 10) && mouseY > (double)pY && mouseY < (double)(pY + ITensuraScrollbar.SCROLLBAR_DATA.scrollbarSpace));
    }

    default public boolean handleScrollbarMouseDragged(double mouseY, int slots) {
        if (!ITensuraScrollbar.SCROLLBAR_DATA.isScrolling || !ITensuraScrollbar.SCROLLBAR_DATA.isActive) {
            return false;
        }
        int i = ITensuraScrollbar.SCROLLBAR_DATA.scrollbarY;
        int j = i + ITensuraScrollbar.SCROLLBAR_DATA.scrollbarSpace;
        float scrollOffs = ((float)mouseY - (float)ITensuraScrollbar.SCROLLBAR_DATA.scrollbarY - 7.5f) / ((float)(j - i) - 15.0f);
        scrollOffs = Mth.m_14036_((float)scrollOffs, (float)0.0f, (float)1.0f);
        SCROLLBAR_DATA.setOffset(scrollOffs);
        this.setStartIndex((int)((double)(scrollOffs * (float)this.getOffscreenRows()) + 0.5) * slots);
        return true;
    }

    default public boolean handleScrollbarMouseScrolled(double delta, int slots) {
        if (!ITensuraScrollbar.SCROLLBAR_DATA.isActive) {
            return false;
        }
        float f = (float)delta / (float)this.getOffscreenRows();
        float scrollOffs = Mth.m_14036_((float)(ITensuraScrollbar.SCROLLBAR_DATA.scrollbarOffset - f), (float)0.0f, (float)1.0f);
        SCROLLBAR_DATA.setOffset(scrollOffs);
        this.setStartIndex((int)((double)(scrollOffs * (float)this.getOffscreenRows()) + 0.5) * slots);
        return true;
    }

    public static class ScrollbarData {
        private int scrollbarX;
        private int scrollbarY;
        private int scrollbarSpace;
        private float scrollbarOffset;
        private boolean isScrolling;
        private boolean isActive;

        private ScrollbarData() {
        }

        public int getX() {
            return this.scrollbarX;
        }

        public void setX(int x) {
            this.scrollbarX = x;
        }

        public int getY() {
            return this.scrollbarY;
        }

        public void setY(int y) {
            this.scrollbarY = y;
        }

        public int getSpace() {
            return this.scrollbarSpace;
        }

        public void setSpace(int space) {
            this.scrollbarSpace = space;
        }

        public float getOffset() {
            return this.scrollbarOffset;
        }

        public void setOffset(float offset) {
            this.scrollbarOffset = offset;
        }

        public boolean getScrolling() {
            return this.isScrolling;
        }

        public void setScrolling(boolean scrolling) {
            this.isScrolling = scrolling;
        }

        public boolean getActive() {
            return this.isActive;
        }

        public void setActive(boolean active) {
            this.isActive = active;
        }
    }
}

