/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.registry.dimensions;

import com.github.manasmods.tensura.registry.biome.TensuraBiomes;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.dimensions.TensuraNoises;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TensuraDimensions {
    public static final DeferredRegister<PoiType> POI = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"tensura");
    public static final DeferredRegister<NoiseGeneratorSettings> NOISE = DeferredRegister.create((ResourceKey)Registry.f_122878_, (String)"tensura");
    public static final ResourceKey<Level> LABYRINTH = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("tensura", "labyrinth"));
    public static final ResourceKey<DimensionType> LABYRINTH_TYPE = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)LABYRINTH.m_135782_());
    public static final RegistryObject<PoiType> LABYRINTH_PORTAL = POI.register("labyrinth_portal", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)TensuraBlocks.LABYRINTH_PORTAL.get()).m_49965_().m_61056_()), 0, 1));
    public static final ResourceKey<Level> HELL = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("tensura", "hell"));
    public static final ResourceKey<DimensionType> HELL_TYPE = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)HELL.m_135782_());
    public static final RegistryObject<NoiseGeneratorSettings> HELL_NOISE = NOISE.register("hell", () -> GenerationNoises.HELL);
    public static final RegistryObject<PoiType> HELL_PORTAL = POI.register("hell_portal", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)TensuraBlocks.HELL_PORTAL.get()).m_49965_().m_61056_()), 0, 1));

    public static void init(IEventBus modEventBus) {
        POI.register(modEventBus);
        NOISE.register(modEventBus);
    }

    public static class GenerationNoises
    extends NoiseRouterData {
        private static final DensityFunction ZERO = DensityFunctions.m_208263_();
        public static final NoiseGeneratorSettings HELL = new NoiseGeneratorSettings(NoiseSettings.m_224525_((int)0, (int)128, (int)2, (int)1), Blocks.f_152491_.m_49966_(), Blocks.f_50016_.m_49966_(), GenerationNoises.hell(), Rules.HELL_DIMENSION, List.of(), 0, false, false, false, false);

        private static Holder<NormalNoise.NoiseParameters> m_209542_(ResourceKey<NormalNoise.NoiseParameters> key) {
            return BuiltinRegistries.f_194654_.m_206081_(key);
        }

        private static DensityFunction m_224443_(DensityFunction func, int i, int i1, int i2, int i3, double v, int i4, int i5, double v1) {
            DensityFunction toReturn = func;
            DensityFunction func1 = DensityFunctions.m_208266_((int)(i + i1 - i2), (int)(i + i1 - i3), (double)1.0, (double)0.0);
            toReturn = DensityFunctions.m_224030_((DensityFunction)func1, (double)v, (DensityFunction)toReturn);
            DensityFunction func2 = DensityFunctions.m_208266_((int)(i + i4), (int)(i + i5), (double)0.0, (double)1.0);
            toReturn = DensityFunctions.m_224030_((DensityFunction)func2, (double)v1, (DensityFunction)toReturn);
            return toReturn;
        }

        private static DensityFunction m_224439_(DensityFunction func, int i, int i1) {
            return GenerationNoises.m_224443_(func, i, i1, 72, -184, -23.4375, 4, 32, -0.234375);
        }

        private static NoiseRouter hell() {
            DensityFunction uFunc1 = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208366_(GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189286_))));
            DensityFunction uFunc2 = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208378_(GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189286_))));
            DensityFunction temperature = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189269_)));
            DensityFunction vegetation = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189278_)));
            DensityFunction continentalness = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189279_)));
            DensityFunction erosion = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189280_)));
            DensityFunction uFunc3 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.05), (DensityFunction)DensityFunctions.m_208368_((Holder)((Holder)TensuraNoises.HELL.getHolder().orElseThrow()), (double)0.6, (double)1.0));
            DensityFunction uFunc4 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.4), (DensityFunction)uFunc3);
            DensityFunction uFunc5 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208266_((int)16, (int)128, (double)1.0, (double)0.0), (DensityFunction)uFunc4);
            DensityFunction uFunc6 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.2), (DensityFunction)uFunc5);
            DensityFunction uFunc7 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.1), (DensityFunction)uFunc6);
            DensityFunction uFunc8 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208266_((int)0, (int)48, (double)0.0, (double)1.0), (DensityFunction)uFunc7);
            DensityFunction uFunc9 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.1), (DensityFunction)uFunc8);
            DensityFunction uFunc10 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.05), (DensityFunction)uFunc9);
            DensityFunction finalDensity = DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208389_((DensityFunction)GenerationNoises.m_224439_(uFunc10, 0, 128))).m_208234_();
            return new NoiseRouter(ZERO, ZERO, ZERO, ZERO, temperature, vegetation, continentalness, erosion, ZERO, ZERO, ZERO, finalDensity, ZERO, ZERO, ZERO);
        }
    }

    public static class Rules {
        private static final SurfaceRules.RuleSource SAND = Rules.makeStateRule(Blocks.f_49992_);
        private static final SurfaceRules.RuleSource RED_SAND = Rules.makeStateRule(Blocks.f_49993_);
        private static final SurfaceRules.RuleSource SANDSTONE = Rules.makeStateRule(Blocks.f_50062_);
        private static final SurfaceRules.RuleSource RED_SANDSTONE = Rules.makeStateRule(Blocks.f_50394_);
        private static final SurfaceRules.RuleSource STONE = Rules.makeStateRule(Blocks.f_50069_);
        private static final SurfaceRules.RuleSource DIORITE = Rules.makeStateRule(Blocks.f_50228_);
        private static final SurfaceRules.RuleSource GRANITE = Rules.makeStateRule(Blocks.f_50122_);
        private static final SurfaceRules.RuleSource ANDESITE = Rules.makeStateRule(Blocks.f_50334_);
        public static final SurfaceRules.RuleSource HELL_DIMENSION = Rules.hell();

        private static SurfaceRules.RuleSource makeStateRule(Block pBlock) {
            return SurfaceRules.m_189390_((BlockState)pBlock.m_49966_());
        }

        private static SurfaceRules.RuleSource hell() {
            SurfaceRules.ConditionSource onCeilingLayer = SurfaceRules.f_189377_;
            SurfaceRules.ConditionSource underCeilingLayer = SurfaceRules.f_189378_;
            SurfaceRules.ConditionSource topLayer = SurfaceRules.f_189375_;
            SurfaceRules.ConditionSource middleLayer = SurfaceRules.f_189376_;
            SurfaceRules.ConditionSource preBottomLayer = SurfaceRules.f_202169_;
            SurfaceRules.ConditionSource bottomLayer = SurfaceRules.f_202170_;
            SurfaceRules.ConditionSource barrens = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TensuraBiomes.UNDERWORLD_BARRENS.getKey()});
            SurfaceRules.RuleSource barrensSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)topLayer, (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)middleLayer, (SurfaceRules.RuleSource)GRANITE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)bottomLayer, (SurfaceRules.RuleSource)DIORITE), ANDESITE});
            SurfaceRules.ConditionSource spikes = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TensuraBiomes.UNDERWORLD_SPIKES.getKey()});
            SurfaceRules.RuleSource spikesSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)topLayer, (SurfaceRules.RuleSource)ANDESITE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)middleLayer, (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)bottomLayer, (SurfaceRules.RuleSource)GRANITE), DIORITE});
            SurfaceRules.ConditionSource sands = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TensuraBiomes.UNDERWORLD_SANDS.getKey()});
            SurfaceRules.RuleSource sandsSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)topLayer, (SurfaceRules.RuleSource)SAND), SANDSTONE});
            SurfaceRules.ConditionSource redSands = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TensuraBiomes.UNDERWORLD_RED_SANDS.getKey()});
            SurfaceRules.RuleSource redSandSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)topLayer, (SurfaceRules.RuleSource)RED_SAND), RED_SANDSTONE});
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)barrens, (SurfaceRules.RuleSource)barrensSurface));
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)spikes, (SurfaceRules.RuleSource)spikesSurface));
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)sands, (SurfaceRules.RuleSource)sandsSurface));
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)redSands, (SurfaceRules.RuleSource)redSandSurface));
            return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
        }
    }
}

