/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.registry.dimensions;

import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.world.savedata.LabyrinthSaveData;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class LabyrinthTeleporter
implements ITeleporter {
    public boolean isVanilla() {
        return false;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        ServerPlayer player;
        if (destWorld.m_46472_() == TensuraDimensions.LABYRINTH) {
            Player player2;
            LabyrinthSaveData saveData = LabyrinthSaveData.get(destWorld.m_7654_().m_129783_());
            Vec3 pos = saveData.getEntrancePos();
            if (entity instanceof Player && (LabyrinthSaveData.isEntityPassedColossus((Entity)(player2 = (Player)entity)) || TensuraEffectsCapability.isColossusWon((LivingEntity)player2))) {
                pos = saveData.getPassedEntrance();
            }
            return new PortalInfo(pos, Vec3.f_82478_, 0.0f, 0.0f);
        }
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_8963_() == destWorld.m_46472_()) {
            BlockPos pos = player.m_8961_();
            if (pos != null) {
                Optional optional = Player.m_36130_((ServerLevel)destWorld, (BlockPos)pos, (float)player.m_8962_(), (boolean)player.m_8964_(), (boolean)true);
                if (optional.isPresent()) {
                    pos = new BlockPos((Vec3)optional.get());
                }
            } else {
                pos = destWorld.m_220360_();
            }
            return new PortalInfo(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Vec3.f_82478_, player.m_8962_(), 0.0f);
        }
        return super.getPortalInfo(entity, destWorld, defaultPortalInfo);
    }
}

