/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.registry;

import com.github.manasmods.tensura.data.TensuraTags;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TensuraStats {
    private static final DeferredRegister<StatType<?>> registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STAT_TYPES, (String)"tensura");
    public static final RegistryObject<StatType<EntityType<?>>> BOSS_KILLED = registry.register("boss_killed", () -> new StatType((Registry)Registry.f_122826_));

    private static ResourceLocation makeCustomStat(String pKey) {
        RegistryObject register = registry.register(pKey, () -> new StatType(Registry.f_122832_));
        return register.getId();
    }

    public static void init(IEventBus modEventBus) {
        registry.register(modEventBus);
    }

    public static int getBossKilled(Player player) {
        StatsCounter statsCounter;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            statsCounter = localPlayer.m_108630_();
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            statsCounter = serverPlayer.m_8951_();
        } else {
            return 0;
        }
        int i = 0;
        for (EntityType type : Registry.f_122826_) {
            if (!type.m_204039_(TensuraTags.EntityTypes.HERO_BOSS) || statsCounter.m_13015_(((StatType)BOSS_KILLED.get()).m_12902_((Object)type)) <= 0) continue;
            ++i;
        }
        return i;
    }
}

