/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.wight;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.vampire.VampireRace;
import com.github.manasmods.tensura.race.wight.WightRace;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class WightKingRace
extends WightRace {
    @Override
    public double getBaseHealth() {
        return 200.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 2.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.1;
    }

    @Override
    public double getSprintSpeed() {
        return 0.2;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)300000.0, (Object)300000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 30.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 2.5;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.SPIRIT_SKELETON.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.SPIRIT_SKELETON.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.WIGHT.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP(player) * 100.0 / (Double)TensuraConfig.INSTANCE.racesConfig.epToWightKing.get();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }

    @Override
    public void raceTick(Player player) {
        if (VampireRace.isUnderSun((LivingEntity)player)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 1, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 1, false, false, false));
            player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FRAGILITY.get(), 40, 1, false, false, false));
        }
    }
}

