/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.orc;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.orc.HighOrcRace;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class OrcLordRace
extends HighOrcRace {
    @Override
    public double getBaseHealth() {
        return 100.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 2.25;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.3;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.25;
    }

    @Override
    public double getSprintSpeed() {
        return 0.4;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)3000.0, (Object)5000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)7000.0, (Object)10000.0);
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)UniqueSkills.STARVED.get()));
        list.add((TensuraSkill)((Object)CommonSkills.SELF_REGENERATION.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.ORC_DISASTER.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.ORC_DISASTER.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ORC_DISASTER.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.HIGH_ORC.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double blood = 0.0;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            blood = localPlayer.m_108630_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.ROYAL_BLOOD.get())));
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            blood = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.ROYAL_BLOOD.get())));
        }
        return blood / (double)((Integer)TensuraConfig.INSTANCE.racesConfig.bloodForOrcLord.get()).intValue() * 100.0;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.consume_requirement", (Object[])new Object[]{((Item)TensuraMobDropItems.ROYAL_BLOOD.get()).m_7968_().m_41611_()}));
        return list;
    }

    @Override
    public void raceTick(Player player) {
        if (!player.f_19853_.m_46469_().m_46207_(TensuraGameRules.HARDCORE_RACE)) {
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 40, 2, false, false, false));
    }
}

