/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.ogre;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.ogre.KijinRace;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class WickedOniRace
extends KijinRace {
    @Override
    public double getBaseHealth() {
        return 100.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 6.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.4;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(1.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.5;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)40000.0, (Object)100000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)40000.0, (Object)100000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 40.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)CommonSkills.STRENGTH.get()));
        list.add((TensuraSkill)((Object)IntrinsicSkills.OGRE_BERSERKER.get()));
        list.add((TensuraSkill)((Object)ExtraSkills.ULTRASPEED_REGENERATION.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.DEATH_ONI.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.DEATH_ONI.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DEATH_ONI.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.KIJIN.get());
        list.add((Race)TensuraRaces.ENLIGHTENED_OGRE.get());
        return list;
    }

    @Override
    public double getManaEvolutionReward() {
        return 80000.0;
    }

    @Override
    public boolean isSpiritual() {
        return true;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double essence = 0.0;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            essence = localPlayer.m_108630_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.DEMON_ESSENCE.get())));
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            essence = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.DEMON_ESSENCE.get())));
        }
        return essence * 100.0 / (double)((Integer)TensuraConfig.INSTANCE.racesConfig.essenceForWicked.get()).intValue();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.consume_requirement", (Object[])new Object[]{((Item)TensuraMobDropItems.DEMON_ESSENCE.get()).m_7968_().m_41611_()}));
        return list;
    }
}

