/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.ogre;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class OgreRace
extends Race {
    public OgreRace() {
        super(Race.Difficulty.EASY);
    }

    public OgreRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 26.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 2.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.1;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.2;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(0.5);
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public double getSprintSpeed() {
        return 0.13;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)1500.0, (Object)2500.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)300.0, (Object)600.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_OGRE.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.SPIRIT_ONI.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.KIJIN.get();
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)CommonSkills.STRENGTH.get()));
        return list;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.KIJIN.get());
        list.add((Race)TensuraRaces.ENLIGHTENED_OGRE.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraEffectsCapability.isColossusPassed((LivingEntity)player) ? 100.0 : 0.0;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.battle_mob_requirement", (Object[])new Object[]{Component.m_237115_((String)((EntityType)TensuraEntityTypes.ELEMENTAL_COLOSSUS.get()).m_20676_().getString())}));
        return list;
    }

    @Override
    public boolean hasGuaranteeElemental() {
        return true;
    }

    @Override
    public double getElementalSpiritsChance(MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        if (elemental.equals((Object)MagicElemental.FLAME)) {
            if (level.equals((Object)SpiritualMagic.SpiritLevel.LESSER)) {
                return 100.0;
            }
            return super.getElementalSpiritsChance(elemental, level) * 2.0;
        }
        return super.getElementalSpiritsChance(elemental, level);
    }
}

