/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.ogre;

import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.ogre.EnlightenedOgreRace;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class MysticOniRace
extends EnlightenedOgreRace {
    @Override
    public double getBaseHealth() {
        return 150.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.6;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.4;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(1.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.5;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)40000.0, (Object)100000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)40000.0, (Object)100000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 40.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.SPIRIT_ONI.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.SPIRIT_ONI.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.KIJIN.get());
        list.add((Race)TensuraRaces.ENLIGHTENED_OGRE.get());
        return list;
    }

    @Override
    public double getAuraEvolutionReward() {
        return 40000.0;
    }

    @Override
    public double getManaEvolutionReward() {
        return 40000.0;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double essence = 0.0;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            essence = localPlayer.m_108630_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.ELEMENTAL_ESSENCE.get())));
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            essence = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.ELEMENTAL_ESSENCE.get())));
        }
        return essence * 100.0 / (double)((Integer)TensuraConfig.INSTANCE.racesConfig.essenceForMystic.get()).intValue();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.consume_requirement", (Object[])new Object[]{((Item)TensuraMobDropItems.ELEMENTAL_ESSENCE.get()).m_7968_().m_41611_()}));
        return list;
    }
}

