/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.ogre;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.ogre.WickedOniRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class DeathOniRace
extends WickedOniRace {
    @Override
    public double getBaseHealth() {
        return 1000.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.7;
    }

    @Override
    public double getSprintSpeed() {
        return 1.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 50.0;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.DIVINE_ONI.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.DIVINE_FIGHTER.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DIVINE_FIGHTER.get());
        list.add((Race)TensuraRaces.DIVINE_ONI.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.WICKED_ONI.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP(player) * 100.0 / (Double)TensuraConfig.INSTANCE.racesConfig.epToSaint.get();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }

    @Override
    public double getAuraEvolutionReward() {
        return 300000.0;
    }

    @Override
    public double getManaEvolutionReward() {
        return 300000.0;
    }
}

