/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.merfolk;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.merfolk.EnlightenedMerfolkRace;
import com.github.manasmods.tensura.registry.TensuraStats;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class MerfolkSaintRace
extends EnlightenedMerfolkRace {
    @Override
    public double getBaseHealth() {
        return 1200.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 3.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.5;
    }

    @Override
    public double getKnockbackResistance() {
        return 2.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(2.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.0;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 50.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.DIVINE_FISH.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.DIVINE_FISH.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DIVINE_FISH.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ENLIGHTENED_MERFOLK.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double ep = Math.min(TensuraPlayerCapability.getBaseEP(player) * 50.0 / (Double)TensuraConfig.INSTANCE.racesConfig.epToSaint.get(), 50.0);
        double boss = Math.min(TensuraStats.getBossKilled(player) * 50 / (Integer)TensuraConfig.INSTANCE.racesConfig.bossForSaint.get(), 50);
        return ep + boss;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.boss_kill_requirement"));
        return list;
    }

    @Override
    public double getAuraEvolutionReward() {
        return 300000.0;
    }

    @Override
    public double getManaEvolutionReward() {
        return 300000.0;
    }

    @Override
    public boolean isSpiritual() {
        return true;
    }
}

