/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.merfolk;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.merfolk.MerfolkSaintRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class DivineFishRace
extends MerfolkSaintRace {
    @Override
    public double getBaseHealth() {
        return 6000.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 5.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 3.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(3.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.2;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 6.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)1000000.0, (Object)1000000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)1000000.0, (Object)1000000.0);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        return new ArrayList<Race>();
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP(player) * 100.0 / (Double)TensuraConfig.INSTANCE.racesConfig.epToDivine.get();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.MERFOLK_SAINT.get());
        return list;
    }

    @Override
    public boolean isDivine() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)((Object)IntrinsicSkills.DIVINE_KI_RELEASE.get()));
        return list;
    }
}

