/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.lizardman;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.lizardman.DragonewtRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TrueDragonewtRace
extends DragonewtRace {
    @Override
    public double getBaseHealth() {
        return 1300.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 5.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.6;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.4;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(1.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)600000.0, (Object)600000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)200000.0, (Object)200000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 50.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)((Object)IntrinsicSkills.DRAGON_SKIN.get()));
        list.add((TensuraSkill)((Object)IntrinsicSkills.FLAME_BREATH.get()));
        list.add((TensuraSkill)((Object)IntrinsicSkills.THUNDER_BREATH.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.DIVINE_DRAGON.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.DIVINE_DRAGON.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DIVINE_DRAGON.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DRAGONEWT.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP(player) * 100.0 / (Double)TensuraConfig.INSTANCE.racesConfig.epToTrueDragonewt.get();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }

    @Override
    public boolean isSpiritual() {
        return true;
    }

    @Override
    public void raceAbility(Player player) {
        if (player.m_20096_()) {
            Vec3 delta = player.m_20184_();
            double dy = delta.f_82480_ <= 0.0 ? 0.5 : delta.f_82480_ + 0.5;
            player.m_20256_(new Vec3(delta.m_7096_(), dy, delta.m_7094_()));
        }
        SkillHelper.riptidePush((LivingEntity)player, 0.5f);
        player.f_19864_ = true;
        player.f_19812_ = true;
        player.m_36320_();
    }
}

