/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.goblin;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class GoblinRace
extends Race {
    public GoblinRace() {
        super(Race.Difficulty.HARD);
    }

    public GoblinRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 12.0;
    }

    @Override
    public float getPlayerSize() {
        return 1.5f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 0.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 3.5;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.08;
    }

    @Override
    public double getSprintSpeed() {
        return this.getMovementSpeed() * 1.3;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)300.0, (Object)300.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)700.0, (Object)700.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.HOBGOBLIN.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.HOBGOBLIN_SAINT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.HOBGOBLIN.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.HOBGOBLIN.get());
        return list;
    }

    @Override
    public boolean hasGuaranteeElemental() {
        return true;
    }

    @Override
    public double getElementalSpiritsChance(MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        if (elemental.equals((Object)MagicElemental.FLAME)) {
            if (level.equals((Object)SpiritualMagic.SpiritLevel.LESSER)) {
                return 100.0;
            }
            return super.getElementalSpiritsChance(elemental, level) * 2.0;
        }
        return super.getElementalSpiritsChance(elemental, level);
    }
}

