/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.dwarf;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class DwarfRace
extends Race {
    public DwarfRace() {
        super(Race.Difficulty.HARD);
    }

    @Override
    public double getBaseHealth() {
        return 24.0;
    }

    @Override
    public float getPlayerSize() {
        return 1.25f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.5;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.09;
    }

    @Override
    public double getSprintSpeed() {
        return 0.117;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)720.0, (Object)1080.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)80.0, (Object)120.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_DWARF.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.DWARF_SAINT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_DWARF.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ENLIGHTENED_DWARF.get());
        return list;
    }

    @Override
    public boolean hasGuaranteeElemental() {
        return true;
    }

    @Override
    public double getElementalSpiritsChance(MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        if (elemental.equals((Object)MagicElemental.EARTH)) {
            if (level.equals((Object)SpiritualMagic.SpiritLevel.LESSER)) {
                return 100.0;
            }
            return super.getElementalSpiritsChance(elemental, level) * 2.0;
        }
        return super.getElementalSpiritsChance(elemental, level);
    }
}

