/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.daemon;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.daemon.DaemonLordRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class DevilLordRace
extends DaemonLordRace {
    public DevilLordRace() {
        super(Race.Difficulty.EASY);
    }

    @Override
    public double getBaseHealth() {
        return 6666.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 5.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 5.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(3.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.4;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)1000000.0, (Object)1000000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)1000000.0, (Object)1000000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return null;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 6.0;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        return new ArrayList<Race>();
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DAEMON_LORD.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double percentage = 0.0;
        if (TensuraEPCapability.getName((LivingEntity)player) != null) {
            percentage += 25.0;
        }
        if (!TensuraPlayerCapability.isSpiritualForm(player)) {
            percentage += 25.0;
        }
        if (TensuraPlayerCapability.isTrueDemonLord(player) || TensuraPlayerCapability.isTrueHero((LivingEntity)player)) {
            percentage += 50.0;
        }
        return percentage;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.name_requirement"));
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.physical_body_requirement"));
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.awaken_requirement", (Object[])new Object[]{Component.m_237115_((String)"tensura.attribute.true_demon_lord.name").m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237115_((String)"tensura.attribute.true_hero.name").m_130940_(ChatFormatting.GOLD)}));
        return list;
    }

    @Override
    public boolean isDivine() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)((Object)IntrinsicSkills.DIVINE_KI_RELEASE.get()));
        return list;
    }
}

