/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.effect.InsanityEffect;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class Race {
    private final Difficulty difficulty;

    public Race(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public abstract double getBaseHealth();

    public abstract float getPlayerSize();

    public abstract double getBaseAttackDamage();

    public abstract double getBaseAttackSpeed();

    public abstract double getKnockbackResistance();

    public abstract double getJumpHeight();

    public abstract double getMovementSpeed();

    public double getSprintSpeed() {
        return this.getMovementSpeed() * 1.3;
    }

    public abstract Pair<Double, Double> getBaseAuraRange();

    public abstract Pair<Double, Double> getBaseMagiculeRange();

    public double getMinBaseAura() {
        return (Double)this.getBaseAuraRange().getFirst();
    }

    public double getMaxBaseAura() {
        return (Double)this.getBaseAuraRange().getSecond();
    }

    public double getMinBaseMagicule() {
        return (Double)this.getBaseMagiculeRange().getFirst();
    }

    public double getMaxBaseMagicule() {
        return (Double)this.getBaseMagiculeRange().getSecond();
    }

    public double getAdditionalSpiritualHealth() {
        return 10.0;
    }

    public double getSpiritualHealthMultiplier() {
        return 2.0;
    }

    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        return new ArrayList<TensuraSkill>();
    }

    public boolean isIntrinsicSkill(Player player, ManasSkill skill) {
        return this.getIntrinsicSkills(player).contains(skill);
    }

    public List<Race> getNextEvolutions(Player player) {
        return new ArrayList<Race>();
    }

    public List<Race> getPreviousEvolutions(Player player) {
        return new ArrayList<Race>();
    }

    @Nullable
    public Race getDefaultEvolution(Player player) {
        return null;
    }

    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return null;
    }

    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    public double getEvolutionPercentage(Player player) {
        double minimalEP = this.getMinBaseMagicule() + this.getMinBaseAura();
        return TensuraPlayerCapability.getBaseEP(player) * 100.0 / minimalEP;
    }

    public void triggerEvolutionRewards(Player player) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (this.getManaEvolutionReward() > 0.0) {
                cap.setBaseMagicule(cap.getBaseMagicule() + this.getManaEvolutionReward(), (LivingEntity)player);
            } else if (cap.getBaseMagicule() < this.getMinBaseMagicule()) {
                cap.setBaseMagicule(this.getMinBaseMagicule(), (LivingEntity)player);
            }
            if (this.getAuraEvolutionReward() > 0.0) {
                cap.setBaseAura(cap.getBaseAura() + this.getAuraEvolutionReward(), (LivingEntity)player);
            } else if (cap.getBaseAura() < this.getMinBaseAura()) {
                cap.setBaseAura(this.getMinBaseAura(), (LivingEntity)player);
            }
        });
        TensuraPlayerCapability.sync(player);
    }

    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }

    public double getAuraEvolutionReward() {
        return 0.0;
    }

    public double getManaEvolutionReward() {
        return 0.0;
    }

    public boolean isMajin() {
        return false;
    }

    public boolean isSpiritual() {
        return false;
    }

    public boolean isDivine() {
        return false;
    }

    public ResourceKey<Level> getRespawnDimension() {
        return Level.f_46428_;
    }

    public boolean passivelyFriendlyWith(LivingEntity entity) {
        return false;
    }

    public boolean canFly() {
        return false;
    }

    public void raceTick(Player player) {
    }

    public void raceAbility(Player player) {
    }

    public boolean canActivateAbility(LivingEntity entity) {
        Player player;
        if (!this.isSpiritual() && entity instanceof Player && !(player = (Player)entity).m_7500_() && TensuraPlayerCapability.isSpiritualForm(player)) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.MOVEMENT_INTERFERENCE.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
            return false;
        }
        if (InsanityEffect.havingNightmare(entity)) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.REST.get())) {
            return false;
        }
        return !entity.m_21023_((MobEffect)TensuraMobEffects.SHADOW_STEP.get());
    }

    public boolean hasGuaranteeElemental() {
        return false;
    }

    public double getElementalSpiritsChance(MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case SpiritualMagic.SpiritLevel.LESSER -> (Double)TensuraConfig.INSTANCE.awakeningConfig.lesserSpiritPercentage.get();
            case SpiritualMagic.SpiritLevel.MEDIUM -> (Double)TensuraConfig.INSTANCE.awakeningConfig.mediumSpiritPercentage.get();
            case SpiritualMagic.SpiritLevel.GREATER -> (Double)TensuraConfig.INSTANCE.awakeningConfig.greaterSpiritPercentage.get();
            case SpiritualMagic.SpiritLevel.LORD -> (Double)TensuraConfig.INSTANCE.awakeningConfig.lordSpiritPercentage.get();
        };
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return TensuraRaces.RACE_REGISTRY.get().getKey((Object)this);
    }

    @Nullable
    public MutableComponent getName() {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return null;
        }
        return Component.m_237115_((String)String.format("%s.race.%s", id.m_135827_(), id.m_135815_().replace('/', '.')));
    }

    public String getNameTranslationKey() {
        return ((TranslatableContents)this.getName().m_214077_()).m_237508_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Race race = (Race)o;
        return this.getRegistryName().equals((Object)race.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.difficulty, this.getBaseHealth()});
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public static enum Difficulty {
        EASY(Component.m_237115_((String)"tensura.race.difficulty.easy").m_130940_(ChatFormatting.GREEN)),
        INTERMEDIATE(Component.m_237115_((String)"tensura.race.difficulty.intermediate").m_130938_(style -> style.m_178520_(Color.ORANGE.getRGB()))),
        HARD(Component.m_237115_((String)"tensura.race.difficulty.hard").m_130940_(ChatFormatting.RED)),
        EXTREME(Component.m_237115_((String)"tensura.race.difficulty.extreme").m_130940_(ChatFormatting.DARK_RED));

        private final MutableComponent name;

        public MutableComponent asText() {
            return this.name;
        }

        private Difficulty(MutableComponent name) {
            this.name = name;
        }
    }
}

