/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillNumberKeyPressPacket {
    private final int keyNumber;
    private final List<ResourceLocation> skillList;

    public RequestSkillNumberKeyPressPacket(FriendlyByteBuf buf) {
        this.skillList = buf.m_236845_(FriendlyByteBuf::m_130281_);
        this.keyNumber = buf.readInt();
    }

    public RequestSkillNumberKeyPressPacket(List<ResourceLocation> skills, int keyNumber) {
        this.skillList = skills;
        this.keyNumber = keyNumber;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236828_(this.skillList, FriendlyByteBuf::m_130085_);
        buf.writeInt(this.keyNumber);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                for (ResourceLocation id : this.skillList) {
                    ManasSkillInstance skillInstance;
                    Optional optional;
                    ManasSkill manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(id);
                    if (manasSkill == null || (optional = storage.getSkill(manasSkill)).isEmpty() || !((skillInstance = (ManasSkillInstance)optional.get()) instanceof TensuraSkillInstance)) continue;
                    TensuraSkillInstance instance = (TensuraSkillInstance)skillInstance;
                    if (!skillInstance.canInteractSkill((LivingEntity)player)) {
                        return;
                    }
                    if (skillInstance.onCoolDown()) {
                        return;
                    }
                    instance.onNumberKeyPress((Player)player, this.keyNumber);
                }
                storage.syncChanges();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

