/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SetSprintSpeedPacket {
    private final double value;

    public SetSprintSpeedPacket(FriendlyByteBuf buf) {
        this.value = buf.readDouble();
    }

    public SetSprintSpeedPacket(double value) {
        this.value = value;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.value);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer == null) {
                return;
            }
            Race race = TensuraPlayerCapability.getRace((LivingEntity)serverPlayer);
            if (race == null) {
                return;
            }
            double newSpeed = Mth.m_14008_((double)this.value, (double)race.getMovementSpeed(), (double)race.getSprintSpeed());
            TensuraPlayerCapability.setSprintSpeed((Player)serverPlayer, newSpeed);
        });
        ctx.get().setPacketHandled(true);
    }
}

