/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.event.NamingEvent;
import com.github.manasmods.tensura.network.play2server.RequestNameKeyPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class RequestNamingGUIPacket {
    private final int targetID;
    private final String name;
    private final NamingType type;

    public RequestNamingGUIPacket(FriendlyByteBuf buf) {
        this.targetID = buf.readInt();
        this.name = buf.m_130277_();
        this.type = (NamingType)buf.m_130066_(NamingType.class);
    }

    public RequestNamingGUIPacket(int id, String name, NamingType type) {
        this.targetID = id;
        this.name = name;
        this.type = type;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.targetID);
        buf.m_130070_(this.name);
        buf.m_130068_((Enum)this.type);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ServerPlayer owner = ((NetworkEvent.Context)ctx.get()).getSender();
            if (owner != null && (entity = owner.f_19853_.m_6815_(this.targetID)) instanceof LivingEntity) {
                LivingEntity sub = (LivingEntity)entity;
                RequestNamingGUIPacket.name(sub, owner, this.type, this.name);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void name(LivingEntity sub, @Nullable ServerPlayer owner, NamingType type, String name) {
        double d;
        if (owner != null && !RequestNameKeyPacket.canName((Player)owner, sub)) {
            return;
        }
        if (sub instanceof Player) {
            Player player = (Player)sub;
            d = TensuraPlayerCapability.getBaseEP(player);
        } else {
            d = TensuraEPCapability.getEP(sub);
        }
        double subEP = d;
        TensuraEPCapability.getFrom(sub).ifPresent(namingCap -> {
            double originalCost = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case NamingType.LOW -> subEP / 2.0;
                case NamingType.MEDIUM -> subEP * 1.5;
                case NamingType.HIGH -> subEP * 9.0;
            };
            NamingEvent event = new NamingEvent(sub, (Player)owner, originalCost, type, name);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            originalCost = event.getOriginalCost();
            double cost = Math.min(event.getCalculatedCost(), (Double)TensuraConfig.INSTANCE.namingConfig.maxCost.get());
            if (owner != null && TensuraPlayerCapability.getMagicule((Player)owner) < cost) {
                owner.m_5661_((Component)Component.m_237115_((String)"tensura.skill.lack_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            namingCap.setName(event.getName());
            sub.m_6593_((Component)Component.m_237113_((String)event.getName()));
            if (owner != null) {
                namingCap.setPermanentOwner(owner.m_20148_());
                TensuraAdvancementsHelper.grant(owner, TensuraAdvancementsHelper.Advancements.NAME_A_MOB);
            }
            sub.f_19853_.m_6263_(null, sub.m_20185_(), sub.m_20186_(), sub.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            sub.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40, 0, false, false, false));
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)sub, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)sub, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
            if (sub instanceof Player) {
                Player player = (Player)sub;
                player.refreshDisplayName();
                if (owner != null) {
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.naming.name_success", (Object[])new Object[]{event.getName(), owner.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.naming.name_success.no_namer", (Object[])new Object[]{event.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                TensuraPlayerCapability.setTrackedRace((LivingEntity)player, null);
                TensuraPlayerCapability.sync(player);
                TensuraEPCapability.sync((LivingEntity)player);
            } else if (owner != null) {
                AbstractHorse horse;
                TamableAnimal tamable;
                if (sub instanceof TamableAnimal && !ForgeEventFactory.onAnimalTame((Animal)(tamable = (TamableAnimal)sub), (Player)owner)) {
                    tamable.m_21828_((Player)owner);
                } else if (sub instanceof AbstractHorse && !ForgeEventFactory.onAnimalTame((Animal)(horse = (AbstractHorse)sub), (Player)owner)) {
                    horse.m_30637_((Player)owner);
                }
            }
            RequestNamingGUIPacket.namingReward(sub, Math.min((Double)TensuraConfig.INSTANCE.namingConfig.maxEPGain.get(), originalCost), event.getType());
            sub.m_5634_(sub.m_21233_());
            SkillHelper.removePredicateEffect(sub, effect -> effect.m_19483_().equals((Object)MobEffectCategory.HARMFUL));
            if (owner != null) {
                TensuraPlayerCapability.getFrom((Player)owner).ifPresent(cap -> {
                    cap.setMagicule(cap.getMagicule() - cost);
                    if (RequestNamingGUIPacket.shouldConsumeMax(event.getType(), (Player)owner)) {
                        cap.setBaseMagicule(cap.getBaseMagicule() - cost, (LivingEntity)owner);
                    }
                    TensuraPlayerCapability.sync((Player)owner);
                });
            }
        });
    }

    private static boolean shouldConsumeMax(NamingType type, Player owner) {
        if (type == NamingType.MEDIUM) {
            return owner.m_217043_().m_216339_(0, 100) <= 10;
        }
        if (type == NamingType.HIGH) {
            return owner.m_217043_().m_216339_(0, 100) <= 30;
        }
        return false;
    }

    public static void namingReward(LivingEntity sub, double gainedEP, NamingType type) {
        if (sub instanceof Player) {
            Player player = (Player)sub;
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setBaseMagicule(cap.getBaseMagicule() + gainedEP / 2.0, sub);
                cap.setBaseAura(cap.getBaseAura() + gainedEP / 2.0, sub);
                cap.setMagicule(cap.getMagicule());
                cap.setAura(cap.getAura());
                TensuraPlayerCapability.sync(player);
                if (type == NamingType.LOW) {
                    return;
                }
                Race race = cap.getRace();
                if (race == null) {
                    return;
                }
                Race evolution = race.getHarvestFestivalEvolution(player);
                if (evolution != null) {
                    RaceHelper.evolveRace(player, evolution, true);
                    sub.f_19853_.m_6263_(null, sub.m_20185_(), sub.m_20186_(), sub.m_20189_(), SoundEvents.f_11887_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (type == NamingType.HIGH) {
                    SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                    for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                        int oldMastery = instance.getMastery();
                        if (oldMastery >= 0 || player.m_217043_().m_188499_()) continue;
                        int masteryChance = player.m_217043_().m_188503_(100);
                        int newMastery = oldMastery + (masteryChance < 50 ? 25 : (masteryChance < 75 ? 50 : (masteryChance < 95 ? 75 : 100)));
                        if (newMastery >= 0) {
                            UnlockSkillEvent event = new UnlockSkillEvent(instance, (Entity)player);
                            if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                            instance.onLearnSkill((LivingEntity)player, event);
                        }
                        instance.setMastery(Math.min(newMastery, 0));
                        instance.markDirty();
                    }
                    storage.syncChanges();
                }
            });
            return;
        }
        TensuraEPCapability.getFrom(sub).ifPresent(cap -> cap.setEP(sub, cap.getEP() + gainedEP));
        if (type != NamingType.LOW) {
            RaceHelper.evolveMobs(sub);
        }
    }

    public static enum NamingType {
        LOW,
        MEDIUM,
        HIGH;

    }
}

