/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.menu.NamingMenu;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class RequestNameKeyPacket {
    public RequestNameKeyPacket(FriendlyByteBuf buf) {
    }

    public RequestNameKeyPacket() {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                if (player.m_36341_()) {
                    TensuraEPCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
                        boolean isNameable = cap.isNameable();
                        cap.setNameable(!isNameable);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.naming.nameable_status", (Object[])new Object[]{!isNameable}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        TensuraEPCapability.sync((LivingEntity)player);
                    });
                } else {
                    LivingEntity sub = SkillHelper.getTargetingEntity((LivingEntity)player, 6.0, false);
                    if (sub != null && RequestNameKeyPacket.canName((Player)player, sub)) {
                        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider(NamingMenu::new, (Component)Component.m_237119_()), buf -> buf.writeInt(sub.m_19879_()));
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static boolean canName(Player player, LivingEntity sub) {
        if (RequestNameKeyPacket.cannotBeNamed(sub)) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.naming.cannot_name").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return false;
        }
        if (SkillHelper.isSubordinate(sub, (LivingEntity)player)) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.naming.name_owner").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return false;
        }
        if (TensuraEPCapability.getName(sub) != null) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.naming.already_named").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return false;
        }
        UUID owner = TensuraEPCapability.getPermanentOwner(sub);
        if (owner != null && !owner.equals(player.m_20148_())) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.naming.had_owner").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return false;
        }
        if (RequestNameKeyPacket.noSubmit(sub, player)) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.naming.not_submit").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return false;
        }
        if (!player.m_7500_() && (sub.m_21023_((MobEffect)TensuraMobEffects.INSANITY.get()) || sub.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()))) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.naming.insane").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return false;
        }
        if (!player.m_7500_() && TensuraEPCapability.getEP(sub) >= TensuraPlayerCapability.getBaseEP(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.naming.lack_EP").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return false;
        }
        return true;
    }

    private static boolean cannotBeNamed(LivingEntity sub) {
        IRanking ranking;
        if (!sub.m_6084_()) {
            return true;
        }
        if (sub instanceof Player) {
            if (!TensuraEPCapability.isNameable(sub)) {
                return true;
            }
            return !sub.f_19853_.m_46469_().m_46207_(TensuraGameRules.PLAYER_NAME);
        }
        if (!sub.m_6095_().m_204039_(TensuraTags.EntityTypes.NAMEABLE)) {
            return true;
        }
        return sub instanceof IRanking && !(ranking = (IRanking)sub).canBeNamed();
    }

    private static boolean noSubmit(LivingEntity sub, Player player) {
        if (player.m_7500_()) {
            return false;
        }
        if (SkillHelper.isSubordinate((LivingEntity)player, sub)) {
            return false;
        }
        if (TensuraEffectsCapability.getEffectSource(sub, (MobEffect)TensuraMobEffects.FEAR.get()) == player) {
            return false;
        }
        if ((double)sub.m_21223_() <= (double)sub.m_21233_() * (Double)TensuraConfig.INSTANCE.namingConfig.lowHPToName.get() / 100.0) {
            return false;
        }
        return TensuraEPCapability.getEP(sub) > TensuraEPCapability.getEP((LivingEntity)player) * (Double)TensuraConfig.INSTANCE.namingConfig.maximumEPToName.get() / 100.0;
    }
}

