/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.unique.GreatSageSkill;
import com.github.manasmods.tensura.block.SmithingBenchBlock;
import com.github.manasmods.tensura.core.AccessorItemCombinerMenu;
import com.github.manasmods.tensura.menu.DegenerateCraftingMenu;
import com.github.manasmods.tensura.menu.DegenerateEnchantmentMenu;
import com.github.manasmods.tensura.menu.ResearcherEnchantmentMenu;
import com.github.manasmods.tensura.menu.ResearcherSpatialStorageMenu;
import com.github.manasmods.tensura.menu.SmithingBenchMenu;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class RequestMenuSwitchPacket {
    private final SwitchType switchType;

    public RequestMenuSwitchPacket(FriendlyByteBuf buf) {
        this.switchType = (SwitchType)buf.m_130066_(SwitchType.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.switchType);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.switchType.handler.accept((NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public RequestMenuSwitchPacket(SwitchType switchType) {
        this.switchType = switchType;
    }

    public static enum SwitchType {
        SMITHING_TO_VANILLA_SMITHING(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt1936$temp = sender.f_36096_;
            if (!(patt1936$temp instanceof SmithingBenchMenu)) {
                return;
            }
            SmithingBenchMenu smithingBenchMenu = (SmithingBenchMenu)patt1936$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, inventory, player) -> new SmithingMenu(windowId, inventory, smithingBenchMenu.getAccess()), (Component)SmithingBenchBlock.TITLE));
        }),
        SMITHING_TO_ANVIL(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt2403$temp = sender.f_36096_;
            if (!(patt2403$temp instanceof SmithingBenchMenu)) {
                return;
            }
            SmithingBenchMenu smithingBenchMenu = (SmithingBenchMenu)patt2403$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, inventory, player) -> new AnvilMenu(windowId, inventory, smithingBenchMenu.getAccess()), (Component)SmithingBenchBlock.TITLE));
        }),
        VANILLA_SMITHING_TO_SMITHING(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt2878$temp = sender.f_36096_;
            if (!(patt2878$temp instanceof SmithingMenu)) {
                return;
            }
            SmithingMenu smithingMenu = (SmithingMenu)patt2878$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new SmithingBenchMenu(pContainerId, pPlayerInventory, ((AccessorItemCombinerMenu)smithingMenu).getAccess()), (Component)SmithingBenchBlock.TITLE));
        }),
        VANILLA_SMITHING_TO_ANVIL(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt3395$temp = sender.f_36096_;
            if (!(patt3395$temp instanceof SmithingMenu)) {
                return;
            }
            SmithingMenu smithingMenu = (SmithingMenu)patt3395$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new AnvilMenu(pContainerId, pPlayerInventory, ((AccessorItemCombinerMenu)smithingMenu).getAccess()), (Component)SmithingBenchBlock.TITLE));
        }),
        ANVIL_TO_SMITHING(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt3896$temp = sender.f_36096_;
            if (!(patt3896$temp instanceof AnvilMenu)) {
                return;
            }
            AnvilMenu anvilMenu = (AnvilMenu)patt3896$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new SmithingBenchMenu(pContainerId, pPlayerInventory, ((AccessorItemCombinerMenu)anvilMenu).getAccess()), (Component)SmithingBenchBlock.TITLE));
        }),
        ANVIL_TO_VANILLA_SMITHING(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt4404$temp = sender.f_36096_;
            if (!(patt4404$temp instanceof AnvilMenu)) {
                return;
            }
            AnvilMenu anvilMenu = (AnvilMenu)patt4404$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new SmithingMenu(pContainerId, pPlayerInventory, ((AccessorItemCombinerMenu)anvilMenu).getAccess()), (Component)SmithingBenchBlock.TITLE));
        }),
        DEGENERATE_TAB_1_TO_TAB_2(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt4907$temp = sender.f_36096_;
            if (!(patt4907$temp instanceof DegenerateCraftingMenu)) {
                return;
            }
            DegenerateCraftingMenu degenerateMenuCrafting = (DegenerateCraftingMenu)patt4907$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new DegenerateEnchantmentMenu(pContainerId, pPlayerInventory, degenerateMenuCrafting.getAccess()), (Component)Component.m_237119_()));
        }),
        DEGENERATE_TAB_2_TO_TAB_1(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt5426$temp = sender.f_36096_;
            if (!(patt5426$temp instanceof DegenerateEnchantmentMenu)) {
                return;
            }
            DegenerateEnchantmentMenu degenerateMenuAnvil = (DegenerateEnchantmentMenu)patt5426$temp;
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new DegenerateCraftingMenu(pContainerId, pPlayerInventory, degenerateMenuAnvil.getAccess()), (Component)Component.m_237119_()));
        }),
        GREAT_SAGE_TAB_1_TO_TAB_2(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            Optional optional = SkillAPI.getSkillsFrom((Entity)sender).getSkill((ManasSkill)UniqueSkills.GREAT_SAGE.get());
            if (optional.isEmpty()) {
                return;
            }
            GreatSageSkill.openGreatSageGUI((LivingEntity)sender, (ManasSkillInstance)optional.get(), 2);
        }),
        GREAT_SAGE_TAB_2_TO_TAB_1(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            Optional optional = SkillAPI.getSkillsFrom((Entity)sender).getSkill((ManasSkill)UniqueSkills.GREAT_SAGE.get());
            if (optional.isEmpty()) {
                return;
            }
            GreatSageSkill.openGreatSageGUI((LivingEntity)sender, (ManasSkillInstance)optional.get(), 1);
        }),
        RESEARCHER_TAB_1_TO_TAB_2(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt6741$temp = sender.f_36096_;
            if (!(patt6741$temp instanceof ResearcherSpatialStorageMenu)) {
                return;
            }
            ResearcherSpatialStorageMenu menu = (ResearcherSpatialStorageMenu)patt6741$temp;
            sender.f_36096_.m_6877_((Player)sender);
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new ResearcherEnchantmentMenu(pContainerId, pPlayerInventory, ContainerLevelAccess.m_39289_((Level)sender.f_19853_, (BlockPos)sender.m_20183_()), menu.getSkill()), (Component)Component.m_237119_()), buf -> buf.m_130085_(SkillUtils.getSkillId(menu.getSkill())));
        }),
        RESEARCHER_TAB_2_TO_TAB_1(context -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt7471$temp = sender.f_36096_;
            if (!(patt7471$temp instanceof ResearcherEnchantmentMenu)) {
                return;
            }
            ResearcherEnchantmentMenu menu = (ResearcherEnchantmentMenu)patt7471$temp;
            Optional skillInstance = SkillAPI.getSkillsFrom((Entity)sender).getSkill(menu.getSkill());
            if (skillInstance.isEmpty()) {
                return;
            }
            ((ManasSkillInstance)skillInstance.get()).onPressed((LivingEntity)sender);
        });

        private final Consumer<NetworkEvent.Context> handler;

        private SwitchType(Consumer<NetworkEvent.Context> handler) {
            this.handler = handler;
        }
    }
}

