/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server;

import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class InsanityActionPacket {
    private final Action action;

    public InsanityActionPacket(FriendlyByteBuf buf) {
        this.action = (Action)buf.m_130066_(Action.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.action);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.action.contextConsumer.accept((NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public InsanityActionPacket(Action action) {
        this.action = action;
    }

    public static enum Action {
        RESET_VALUE(context -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            TensuraEffectsCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
                cap.setInsanityFOV(0);
                cap.setInsanityNightmare(0);
                TensuraEffectsCapability.sync((LivingEntity)player);
            });
        });

        private final Consumer<NetworkEvent.Context> contextConsumer;

        private Action(Consumer<NetworkEvent.Context> contextConsumer) {
            this.contextConsumer = contextConsumer;
        }
    }
}

