/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2client;

import com.github.manasmods.tensura.capability.effects.ITensuraEffectsCapability;
import com.github.manasmods.tensura.network.play2client.ClientAccess;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncEffectsCapabilityPacket {
    private final CompoundTag tag;
    private final int entityId;

    public SyncEffectsCapabilityPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130261_();
        this.entityId = buf.readInt();
    }

    public SyncEffectsCapabilityPacket(ITensuraEffectsCapability data, int entityId) {
        this.tag = (CompoundTag)data.serializeNBT();
        this.entityId = entityId;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientAccess.updateEffectsCapability(this.entityId, this.tag)));
        ctx.get().setPacketHandled(true);
    }
}

