/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2client;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.api.entity.subclass.ILivingPartEntity;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.magicule.MagiculeChunkCapabilityImpl;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.capability.smithing.SmithingCapability;
import com.github.manasmods.tensura.client.screen.FalsifierScreen;
import com.github.manasmods.tensura.client.screen.GreatSageCraftingScreen;
import com.github.manasmods.tensura.client.screen.GreatSageRefiningScreen;
import com.github.manasmods.tensura.client.screen.HumanoidNPCScreen;
import com.github.manasmods.tensura.client.screen.ResearcherSpatialStorageScreen;
import com.github.manasmods.tensura.client.screen.SettingsScreen;
import com.github.manasmods.tensura.client.screen.SpatialStorageScreen;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.menu.GreatSageCraftingMenu;
import com.github.manasmods.tensura.menu.GreatSageRefiningMenu;
import com.github.manasmods.tensura.menu.HumanoidNPCMenu;
import com.github.manasmods.tensura.menu.ResearcherSpatialStorageMenu;
import com.github.manasmods.tensura.menu.SpatialStorageMenu;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.network.play2client.ClientboundMainScreenOpenPacket;
import com.github.manasmods.tensura.network.play2client.ClientboundNPCScreenOpenPacket;
import com.github.manasmods.tensura.network.play2client.ClientboundSpatialStorageOpenPacket;
import com.github.manasmods.tensura.network.play2client.RequestPartHurtAnimation;
import com.github.manasmods.tensura.network.play2client.SyncMagiculePacket;
import com.lowdragmc.photon.client.fx.BlockEffect;
import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

class ClientAccess {
    static final Minecraft minecraft = Minecraft.m_91087_();

    ClientAccess() {
    }

    static void updatePlayerCapability(int entityId, CompoundTag tag) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraPlayerCapability.getFrom(player).ifPresent(data -> data.deserializeNBT((Tag)tag));
            player.m_6210_();
        }
    }

    static void updateSmithingCapability(int entityId, CompoundTag tag) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SmithingCapability.getFrom(player).ifPresent(data -> data.deserializeNBT((Tag)tag));
        }
    }

    static void updateEffectsCapability(int entityId, CompoundTag tag) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            TensuraEffectsCapability.getFrom(living).ifPresent(data -> data.deserializeNBT((Tag)tag));
        }
    }

    static void updateEPCapability(int entityId, CompoundTag tag) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            TensuraEPCapability.getFrom(living).ifPresent(data -> data.deserializeNBT((Tag)tag));
        }
    }

    static void updateSkillCapability(int entityId, CompoundTag tag) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraSkillCapability.getFrom(player).ifPresent(data -> data.deserializeNBT((Tag)tag));
        }
    }

    public static void updateMagicule(SyncMagiculePacket packet) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        MagiculeChunkCapabilityImpl.get(ClientAccess.minecraft.f_91073_.m_6325_(packet.getPos().f_45578_, packet.getPos().f_45579_)).deserializeNBT((Tag)packet.getTag());
    }

    public static void handleClientboundMainScreenOpenPacket(ClientboundMainScreenOpenPacket message, Supplier<NetworkEvent.Context> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientLevel level = player.f_108545_;
        if (level.m_6815_(message.entityId) != player) {
            return;
        }
        switch (message.screenID) {
            case 8: {
                Minecraft.m_91087_().m_91152_((Screen)new SettingsScreen());
                break;
            }
            case 9: {
                Minecraft.m_91087_().m_91152_((Screen)new FalsifierScreen());
            }
        }
    }

    public static void handleClientboundSpatialStorageOpenPacket(ClientboundSpatialStorageOpenPacket message, Supplier<NetworkEvent.Context> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_19879_() != message.userId) {
            return;
        }
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(message.skill);
        if (skill == null) {
            return;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(skill);
        if (optional.isEmpty()) {
            return;
        }
        SpatialStorageContainer container = new SpatialStorageContainer(message.size, message.stackSize);
        SpatialStorageMenu menu = new SpatialStorageMenu(message.containerId, player.m_150109_(), (Player)player, container, skill);
        player.f_36096_ = menu;
        Minecraft.m_91087_().m_91152_((Screen)new SpatialStorageScreen(menu, player.m_150109_(), (Component)Objects.requireNonNull(skill.getName())));
    }

    public static void handleClientboundResearcherStorageOpenPacket(ClientboundSpatialStorageOpenPacket message, Supplier<NetworkEvent.Context> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_19879_() != message.userId) {
            return;
        }
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(message.skill);
        if (skill == null) {
            return;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(skill);
        if (optional.isEmpty()) {
            return;
        }
        SpatialStorageContainer container = new SpatialStorageContainer(message.size, message.stackSize);
        ResearcherSpatialStorageMenu menu = new ResearcherSpatialStorageMenu(message.containerId, player.m_150109_(), (Player)player, container, skill);
        player.f_36096_ = menu;
        Minecraft.m_91087_().m_91152_((Screen)new ResearcherSpatialStorageScreen(menu, player.m_150109_(), (Component)Objects.requireNonNull(skill.getName())));
    }

    public static void handleClientboundSpatialCraftingOpenPacket(ClientboundSpatialStorageOpenPacket message, Supplier<NetworkEvent.Context> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_19879_() != message.userId) {
            return;
        }
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(message.skill);
        if (skill == null) {
            return;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(skill);
        if (optional.isEmpty()) {
            return;
        }
        SpatialStorageContainer container = new SpatialStorageContainer(message.size, message.stackSize);
        GreatSageCraftingMenu menu = new GreatSageCraftingMenu(message.containerId, player.m_150109_(), (Player)player, container, skill, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)player.m_20183_()));
        player.f_36096_ = menu;
        Minecraft.m_91087_().m_91152_((Screen)new GreatSageCraftingScreen(menu, player.m_150109_()));
    }

    public static void handleClientboundSpatialRefiningOpenPacket(ClientboundSpatialStorageOpenPacket message, Supplier<NetworkEvent.Context> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_19879_() != message.userId) {
            return;
        }
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(message.skill);
        if (skill == null) {
            return;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(skill);
        if (optional.isEmpty()) {
            return;
        }
        SpatialStorageContainer container = new SpatialStorageContainer(message.size, message.stackSize);
        GreatSageRefiningMenu menu = new GreatSageRefiningMenu(message.containerId, player.m_150109_(), (Player)player, container, skill, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)player.m_20183_()));
        player.f_36096_ = menu;
        Minecraft.m_91087_().m_91152_((Screen)new GreatSageRefiningScreen(menu, player.m_150109_()));
    }

    public static void handleClientboundNPCScreenOpenPacket(ClientboundNPCScreenOpenPacket message, Supplier<NetworkEvent.Context> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientLevel level = player.f_108545_;
        Entity entity = level.m_6815_(message.entityId);
        if (entity instanceof HumanoidNPCEntity) {
            HumanoidNPCEntity npc = (HumanoidNPCEntity)entity;
            if (!npc.m_21830_((LivingEntity)player)) {
                return;
            }
            SimpleContainer simpleContainer = new SimpleContainer(message.size);
            HumanoidNPCMenu menu = new HumanoidNPCMenu(message.containerId, player.m_150109_(), (Container)simpleContainer, npc, message.EP);
            player.f_36096_ = menu;
            Minecraft.m_91087_().m_91152_((Screen)new HumanoidNPCScreen(menu, player.m_150109_(), npc, message.EP));
        }
    }

    static void displayItemLikeTotem(ItemStack stack) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        ClientAccess.minecraft.f_91063_.m_109113_(stack);
    }

    public static void summonFX(ResourceLocation location, int entityId, double xOffset, double yOffset, double zOffset, double xRot, double yRot, double zRot, boolean multi, boolean forceDeath) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        FX fx = FXHelper.getFX((ResourceLocation)location);
        if (fx != null) {
            Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
            EntityEffect entityEffect = new EntityEffect(fx, (Level)ClientAccess.minecraft.f_91073_, entity);
            entityEffect.setXOffset(xOffset);
            entityEffect.setYOffset(yOffset);
            entityEffect.setZOffset(zOffset);
            entityEffect.setAllowMulti(multi);
            entityEffect.setForcedDeath(forceDeath);
            entityEffect.setRotation(xRot, yRot, zRot);
            entityEffect.start();
        }
    }

    public static void summonFX(ResourceLocation location, BlockPos pos, double xOffset, double yOffset, double zOffset, int delay, boolean multi) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        FX fx = FXHelper.getFX((ResourceLocation)location);
        if (fx != null) {
            BlockEffect blockEffect = new BlockEffect(fx, (Level)ClientAccess.minecraft.f_91073_, pos);
            blockEffect.setXOffset(xOffset);
            blockEffect.setYOffset(yOffset);
            blockEffect.setZOffset(zOffset);
            blockEffect.setAllowMulti(multi);
            blockEffect.setDelay(delay);
            blockEffect.start();
        }
    }

    public static void removeClientSkill(ResourceLocation location, int entityId) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(location);
        if (skill == null) {
            return;
        }
        SkillAPI.getSkillsFrom((Entity)entity).forgetSkill(skill);
    }

    public static void updateDimension(int entityId) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = ClientAccess.minecraft.f_91073_.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        entity.m_6210_();
    }

    public static void updatePartHurtAnimation(RequestPartHurtAnimation message) {
        if (ClientAccess.minecraft.f_91073_ == null) {
            return;
        }
        Entity part = ClientAccess.minecraft.f_91073_.m_6815_(message.part);
        Entity parent = ClientAccess.minecraft.f_91073_.m_6815_(message.parent);
        if (part instanceof ILivingPartEntity) {
            ILivingPartEntity multipart = (ILivingPartEntity)part;
            if (parent instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)parent;
                multipart.onServerHurt(living);
            }
        }
    }
}

