/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.menu.slot.spatial;

import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.menu.SpatialStorageMenu;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;

public class LavaStorageInputSlot
extends Slot {
    private final SpatialStorageMenu menu;

    public LavaStorageInputSlot(SpatialStorageMenu menu, Container container, int xPosition, int yPosition) {
        super(container, 1, xPosition, yPosition);
        this.menu = menu;
    }

    public int m_6641_() {
        return 1;
    }

    public boolean m_5857_(ItemStack pStack) {
        if (!PotionUtils.m_43571_((ItemStack)pStack).isEmpty()) {
            return false;
        }
        ItemStack output = LavaStorage.getOutputStack(pStack);
        if (output.m_41619_()) {
            return false;
        }
        ItemStack currentOutput = this.menu.lavaStorageOutput.m_8020_(0);
        if (currentOutput.m_41619_()) {
            return true;
        }
        if (currentOutput.m_41613_() >= currentOutput.m_41741_()) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)output, (ItemStack)currentOutput);
    }

    public void m_5852_(ItemStack pStack) {
        super.m_5852_(pStack);
        Player player = this.menu.getPlayer();
        for (LavaStorage lava : LavaStorage.values()) {
            if (!lava.getInput().equals(pStack.m_41720_())) continue;
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                double point = cap.getLavaPoint() + lava.getLavaPoint();
                if (point < 0.0 || cap.getLavaPoint() >= 10000.0 && lava.getLavaPoint() > 0.0) {
                    return;
                }
                cap.setLavaPoint(point);
                TensuraSkillCapability.sync(player);
                player.m_216990_(this.soundEvent(lava.getLavaPoint()));
                ItemStack currentOutput = this.menu.lavaStorageOutput.m_8020_(0);
                if (currentOutput.m_41619_()) {
                    this.menu.lavaStorageOutput.m_6836_(0, lava.getOutput().m_7968_());
                } else {
                    ItemStack newOutput = currentOutput.m_41777_();
                    newOutput.m_41769_(1);
                    this.menu.lavaStorageOutput.m_6836_(0, newOutput);
                }
                this.menu.lavaStorageOutput.m_6596_();
                this.f_40218_.m_6836_(1, ItemStack.f_41583_);
                this.f_40218_.m_6596_();
            });
        }
    }

    private SoundEvent soundEvent(double point) {
        if (point > 0.0) {
            return SoundEvents.f_11780_;
        }
        return SoundEvents.f_11783_;
    }

    public static enum LavaStorage {
        MAGMA_BLOCK(Items.f_42258_, 1.0, Items.f_42594_),
        LAVE_BUCKET(Items.f_42448_, 3.0, Items.f_42446_),
        BUCKET(Items.f_42446_, -3.0, Items.f_42448_);

        private final Item input;
        private final double lavaPoint;
        private final Item output;

        public static ItemStack getOutputStack(ItemStack input) {
            Optional<Item> output = Arrays.stream(LavaStorage.values()).filter(lavaStorage -> lavaStorage.getInput().equals(input.m_41720_())).map(LavaStorage::getOutput).findFirst();
            return output.map(Item::m_7968_).orElse(ItemStack.f_41583_);
        }

        public Item getInput() {
            return this.input;
        }

        public double getLavaPoint() {
            return this.lavaPoint;
        }

        public Item getOutput() {
            return this.output;
        }

        private LavaStorage(Item input, double lavaPoint, Item output) {
            this.input = input;
            this.lavaPoint = lavaPoint;
            this.output = output;
        }
    }
}

