/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.menu;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.data.pack.GearEPCount;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.menu.container.TensuraCraftingContainer;
import com.github.manasmods.tensura.menu.slot.spatial.SpatialSlot;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearcherSpatialStorageMenu
extends AbstractContainerMenu {
    private static final Logger log = LogManager.getLogger(ResearcherSpatialStorageMenu.class);
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int INVENTORY_ROW_COUNT = 3;
    private static final int INVENTORY_COLUMN_COUNT = 9;
    private final ManasSkill skill;
    private final ContainerLevelAccess access = ContainerLevelAccess.f_39287_;
    private final Player player;
    private final SpatialStorageContainer container;
    private final SpatialStorageContainer furnaceInputContainer;
    private final DataSlot startIndex = DataSlot.m_39401_();
    private final Slot craftingResultSlot;
    private final Slot furnaceInputSlot;
    private final Slot furnaceResultSlot;
    private final TensuraCraftingContainer craftingGridContainer;
    private final ResultContainer craftingResultContainer = new ResultContainer();
    private final ResultContainer furnaceResultContainer;
    private int removeCount;

    public ResearcherSpatialStorageMenu(int id, Inventory inv, Player player, SpatialStorageContainer container, ManasSkill skill) {
        super(null, id);
        this.skill = skill;
        this.player = player;
        this.container = container;
        ResearcherSpatialStorageMenu.m_38869_((Container)container, (int)this.getStorageSize());
        this.m_38895_(this.startIndex).m_6422_(0);
        container.m_5856_(player);
        this.craftingGridContainer = new TensuraCraftingContainer(this, 3, 3);
        this.craftingResultSlot = new Slot((Container)this.craftingResultContainer, 0, 232, 58){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                super.m_142406_(pPlayer, pStack);
                if (pStack.m_41619_()) {
                    return;
                }
                ResearcherSpatialStorageMenu.this.itemCrafted(pStack);
                ResearcherSpatialStorageMenu.this.slotChangedCraftingGrid();
            }

            @NotNull
            public ItemStack m_6201_(int pAmount) {
                if (this.m_6657_()) {
                    ResearcherSpatialStorageMenu.this.removeCount += Math.min(pAmount, this.m_7993_().m_41613_());
                }
                return super.m_6201_(pAmount);
            }

            protected void m_7169_(ItemStack pStack, int pAmount) {
                ResearcherSpatialStorageMenu.this.removeCount += pAmount;
                if (pStack.m_41619_()) {
                    return;
                }
                ResearcherSpatialStorageMenu.this.itemCrafted(pStack);
                if (!ResearcherSpatialStorageMenu.this.craftingGridContainer.m_7983_()) {
                    ResearcherSpatialStorageMenu.this.slotChangedCraftingGrid();
                }
                this.m_5845_(pStack);
            }

            protected void m_6405_(int pNumItemsCrafted) {
                ResearcherSpatialStorageMenu.this.removeCount += pNumItemsCrafted;
            }
        };
        this.furnaceInputContainer = new SpatialStorageContainer(1, 128);
        this.furnaceInputSlot = new Slot((Container)this.furnaceInputContainer, 0, 183, 107){

            public void m_5852_(ItemStack pStack) {
                super.m_5852_(pStack);
                ResearcherSpatialStorageMenu.this.slotChangedFurnaceInput();
            }
        };
        this.furnaceResultContainer = new ResultContainer(){

            public int m_6893_() {
                return ResearcherSpatialStorageMenu.this.getMaxStack();
            }
        };
        this.furnaceResultSlot = new Slot((Container)this.furnaceResultContainer, 0, 224, 107){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                super.m_142406_(pPlayer, pStack);
                if (!ResearcherSpatialStorageMenu.this.furnaceInputContainer.m_7983_()) {
                    ResearcherSpatialStorageMenu.this.slotChangedFurnaceInput();
                }
            }
        };
        this.addSpatialSlots();
        this.addFurnaceSlots();
        this.addCraftingSlots();
        this.addPlayerInventory(inv);
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.startIndex.m_6422_(pId);
            this.container.m_6596_();
            this.m_6199_((Container)this.container);
            this.f_38839_.forEach(Slot::m_6654_);
            return true;
        }
        return super.m_6366_(pPlayer, pId);
    }

    private void slotChangedCraftingGrid() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = serverPlayer.m_9236_();
        MinecraftServer server = serverPlayer.m_20194_();
        if (server == null) {
            return;
        }
        ItemStack stack = ItemStack.f_41583_;
        Optional optional = server.m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.craftingGridContainer, (Level)level);
        if (optional.isEmpty()) {
            this.craftingResultContainer.m_6211_();
            this.craftingResultContainer.m_6596_();
            return;
        }
        CraftingRecipe recipe = (CraftingRecipe)optional.get();
        if (this.craftingResultContainer.m_40135_((Level)level, serverPlayer, (Recipe)recipe)) {
            stack = recipe.m_5874_((Container)this.craftingGridContainer);
        }
        this.craftingResultContainer.m_6836_(0, stack);
        this.m_150404_(0, stack);
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, stack));
    }

    private void slotChangedFurnaceInput() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = serverPlayer.m_9236_();
        MinecraftServer server = serverPlayer.m_20194_();
        if (server == null) {
            return;
        }
        Optional optional = server.m_129894_().m_44015_(RecipeType.f_44108_, (Container)this.furnaceInputContainer, (Level)level);
        if (optional.isEmpty()) {
            return;
        }
        SmeltingRecipe recipe = (SmeltingRecipe)optional.get();
        ItemStack stack = recipe.m_5874_((Container)this.furnaceInputContainer);
        ItemStack resultContainerItem = this.furnaceResultContainer.m_8020_(0);
        if (!resultContainerItem.m_41619_() && !resultContainerItem.m_150930_(stack.m_41720_())) {
            return;
        }
        if (!this.furnaceResultContainer.m_40135_((Level)level, serverPlayer, (Recipe)recipe)) {
            return;
        }
        int countToSet = 0;
        int countToRemove = 0;
        int recipeItemCount = stack.m_41613_();
        int resultContainerItemCount = resultContainerItem.m_41613_();
        int size = this.furnaceInputContainer.m_8020_(0).m_41613_();
        if (resultContainerItemCount == this.getMaxStack()) {
            return;
        }
        while (resultContainerItemCount + recipeItemCount + countToSet <= this.getMaxStack() && size - countToRemove > 0) {
            countToSet += recipeItemCount;
            ++countToRemove;
        }
        stack.m_41764_(countToSet + resultContainerItemCount);
        this.furnaceInputContainer.m_8020_(0).m_41774_(countToRemove);
        this.furnaceResultContainer.m_6836_(0, stack);
        this.m_150404_(0, stack);
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, stack));
        this.furnaceResultContainer.m_8015_((Player)serverPlayer);
        this.player.m_6330_(SoundEvents.f_12031_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.getStorageSize();
    }

    public int getStartIndex() {
        return this.startIndex.m_6501_();
    }

    public int getStorageSize() {
        return this.container.m_6643_();
    }

    public int getMaxStack() {
        return this.container.m_6893_();
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 145 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 203));
        }
    }

    private void addSpatialSlots() {
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 8; ++y) {
                this.m_38897_(new SpatialSlot(this, (Container)this.container, y + x * 8, 8 + y * 18, 44 + x * 18));
            }
        }
    }

    private void addCraftingSlots() {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.m_38897_(new Slot((Container)this.craftingGridContainer, y + x * 3, 174 + y * 18, 40 + x * 18){

                    public void m_5852_(ItemStack pStack) {
                        super.m_5852_(pStack);
                        ResearcherSpatialStorageMenu.this.slotChangedCraftingGrid();
                    }
                });
            }
        }
        this.m_38897_(this.craftingResultSlot);
    }

    private void addFurnaceSlots() {
        this.m_38897_(this.furnaceInputSlot);
        this.m_38897_(this.furnaceResultSlot);
    }

    private void itemCrafted(ItemStack stack) {
        if (this.removeCount > 0) {
            stack.m_41678_(this.player.f_19853_, this.player, this.removeCount);
            ForgeEventFactory.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.craftingGridContainer);
        }
        this.removeCount = 0;
        if (this.skill == UniqueSkills.GODLY_CRAFTSMAN.get()) {
            for (GearEPCount gearEPCount : TensuraData.getGearEP()) {
                if (!Objects.equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), gearEPCount.getItem())) continue;
                CompoundTag tag = stack.m_41784_();
                double maxEP = gearEPCount.getMaxEP();
                if (tag.m_128459_("MaxEP") < maxEP) {
                    tag.m_128347_("MaxEP", maxEP);
                }
                double chance = (double)this.player.m_217043_().m_216339_(1, 5) * 0.25;
                if (SkillUtils.isSkillMastered((LivingEntity)this.player, (ManasSkill)UniqueSkills.GODLY_CRAFTSMAN.get())) {
                    chance = Math.min(chance + 0.25, 1.0);
                }
                double EP = (double)gearEPCount.getMinEP() + chance * (maxEP - (double)gearEPCount.getMinEP());
                tag.m_128347_("EP", EP);
                tag.m_128347_("durabilityEP", EP);
                break;
            }
        }
        ForgeHooks.setCraftingPlayer((Player)this.player);
        NonNullList list = this.player.f_19853_.m_7465_().m_44069_(RecipeType.f_44107_, (Container)this.craftingGridContainer, this.player.f_19853_);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack slotStack = this.craftingGridContainer.m_8020_(i);
            ItemStack recipeStack = (ItemStack)list.get(i);
            if (!slotStack.m_41619_()) {
                this.craftingGridContainer.m_7407_(i, 1);
                slotStack = this.craftingGridContainer.m_8020_(i);
            }
            if (recipeStack.m_41619_()) continue;
            if (slotStack.m_41619_()) {
                this.craftingGridContainer.m_6836_(i, recipeStack);
                continue;
            }
            if (ItemStack.m_41746_((ItemStack)slotStack, (ItemStack)recipeStack) && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)recipeStack)) {
                recipeStack.m_41769_(slotStack.m_41613_());
                this.craftingGridContainer.m_6836_(i, recipeStack);
                continue;
            }
            if (this.player.m_150109_().m_36054_(recipeStack)) continue;
            this.player.m_36176_(recipeStack, false);
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    @Nullable
    private ManasSkillInstance getSkillInstance(Player player) {
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(this.skill);
        return optional.orElse(null);
    }

    public void m_6877_(Player pPlayer) {
        ManasSkill manasSkill;
        ManasSkillInstance instance = this.getSkillInstance(pPlayer);
        if (instance != null && (manasSkill = instance.getSkill()) instanceof ISpatialStorage) {
            ISpatialStorage spatialStorage = (ISpatialStorage)manasSkill;
            spatialStorage.saveContainer(instance, (LivingEntity)pPlayer, this.container);
        }
        this.container.m_5785_(pPlayer);
        this.m_150411_(pPlayer, (Container)this.craftingGridContainer);
        this.m_150411_(pPlayer, (Container)this.furnaceInputContainer);
        this.m_150411_(pPlayer, (Container)this.furnaceResultContainer);
        this.craftingResultContainer.m_6211_();
        super.m_6877_(pPlayer);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack copy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (!slot.m_6657_()) {
            return copy;
        }
        ItemStack stack = slot.m_7993_();
        copy = stack.m_41777_();
        if (pIndex < 52 ? !this.m_38903_(stack, 52, 88, true) : !this.m_38903_(stack, 0, 52, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(pPlayer, stack);
        if (slot.f_40219_ == 51) {
            this.itemCrafted(stack);
            this.slotChangedCraftingGrid();
        }
        return copy;
    }

    protected boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.m_41753_()) {
            while (!pStack.m_41619_() && !(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && slot.m_5857_(pStack) && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + pStack.m_41613_();
                    int n = maxSize = i < 42 ? this.container.m_6893_() : Math.min(itemstack.m_41741_(), slot.m_6641_());
                    if (j <= maxSize) {
                        pStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        pStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot pSlot = (Slot)this.f_38839_.get(i);
                ItemStack stack = pSlot.m_7993_();
                if (stack.m_41619_() && pSlot.m_5857_(pStack)) {
                    if (pStack.m_41613_() > pSlot.m_6641_()) {
                        pSlot.m_5852_(pStack.m_41620_(pSlot.m_6641_()));
                    } else {
                        pSlot.m_5852_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    pSlot.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ManasSkill getSkill() {
        return this.skill;
    }

    public ContainerLevelAccess getAccess() {
        return this.access;
    }

    public Player getPlayer() {
        return this.player;
    }
}

