/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.menu;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.skill.unique.ResearcherSkill;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.registry.menu.TensuraMenuTypes;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ResearcherEnchantmentMenu
extends AbstractContainerMenu {
    private final Player player;
    private final ContainerLevelAccess access;
    private final ManasSkill skill;
    private final SimpleContainer bookInput;
    private final SimpleContainer itemInput;
    private final SimpleContainer itemOutput;
    private final Map<Enchantment, Integer> oldEnchantments = new HashMap<Enchantment, Integer>();
    public boolean mayPickup = false;

    public ResearcherEnchantmentMenu(int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        this(pContainerId, inventory, ContainerLevelAccess.f_39287_, (ManasSkill)SkillAPI.getSkillRegistry().getValue(buf.m_130281_()));
    }

    public ResearcherEnchantmentMenu(int pContainerId, Inventory inventory, ContainerLevelAccess access, final @Nullable ManasSkill skill) {
        super((MenuType)TensuraMenuTypes.RESEARCHER_ENCHANTMENT_MENU.get(), pContainerId);
        this.access = access;
        this.player = inventory.f_35978_;
        this.skill = skill;
        this.addPlayerInventorySlots(inventory);
        this.bookInput = new SimpleContainer(1);
        this.itemInput = new SimpleContainer(1);
        this.itemOutput = new SimpleContainer(1);
        this.m_38897_(new Slot((Container)this.bookInput, 0, 64, 44){

            public int m_6641_() {
                return 1;
            }

            public void m_5852_(ItemStack pStack) {
                boolean book;
                super.m_5852_(pStack);
                boolean bl = book = pStack.m_150930_(Items.f_42690_) || skill == UniqueSkills.GODLY_CRAFTSMAN.get();
                if (book && !ResearcherEnchantmentMenu.this.player.f_19853_.m_5776_()) {
                    if (ResearcherSkill.addEnchantments((LivingEntity)ResearcherEnchantmentMenu.this.player, EnchantmentHelper.m_44831_((ItemStack)pStack), skill)) {
                        if (pStack.m_150930_(Items.f_42690_)) {
                            ResearcherEnchantmentMenu.this.bookInput.m_6211_();
                            ResearcherEnchantmentMenu.this.player.m_6330_(SoundEvents.f_11713_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        } else {
                            ItemStack copy = pStack.m_41777_();
                            EnchantmentHelper.m_44865_(Map.of(), (ItemStack)copy);
                            ResearcherEnchantmentMenu.this.bookInput.m_6836_(0, copy);
                            ResearcherEnchantmentMenu.this.player.m_6330_(SoundEvents.f_11998_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        ResearcherEnchantmentMenu.this.addSkillMastery();
                    }
                    ResearcherEnchantmentMenu.this.m_6199_(this.f_40218_);
                }
            }

            public boolean m_5857_(ItemStack pStack) {
                return super.m_5857_(pStack) && (pStack.m_150930_(Items.f_42690_) || skill == UniqueSkills.GODLY_CRAFTSMAN.get());
            }
        });
        this.m_38897_(new Slot((Container)this.itemInput, 0, 147, 67){

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
                if (ResearcherEnchantmentMenu.this.mayPickup) {
                    return;
                }
                if (!this.shouldUpdateEnchantedItem(this.m_7993_(), ResearcherEnchantmentMenu.this.itemOutput.m_8020_(0))) {
                    return;
                }
                this.m_7993_().m_41784_().m_128405_("EnchantingId", ResearcherEnchantmentMenu.this.player.f_19797_);
                ResearcherSkill.addSelectedEnchantments((LivingEntity)ResearcherEnchantmentMenu.this.player, EnchantmentHelper.m_44831_((ItemStack)this.m_7993_()), true, skill);
                ResearcherEnchantmentMenu.this.itemOutput.m_6836_(0, this.m_7993_().m_41777_());
                ResearcherEnchantmentMenu.this.oldEnchantments.clear();
                ResearcherEnchantmentMenu.this.oldEnchantments.putAll(ResearcherSkill.getSelectedEnchantments((LivingEntity)ResearcherEnchantmentMenu.this.player, skill));
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                super.m_142406_(pPlayer, pStack);
                pStack.m_41749_("EnchantingId");
            }

            protected void m_7169_(ItemStack pStack, int pAmount) {
                super.m_7169_(pStack, pAmount);
                pStack.m_41749_("EnchantingId");
            }

            public void m_40234_(ItemStack pOldStack, ItemStack pNewStack) {
                super.m_40234_(pOldStack, pNewStack);
                pOldStack.m_41749_("EnchantingId");
            }

            private boolean shouldUpdateEnchantedItem(ItemStack input, ItemStack output) {
                if (input.m_41619_() || output.m_41619_()) {
                    return true;
                }
                if (!input.m_41656_(output)) {
                    return true;
                }
                if (input.m_41783_() == null || output.m_41783_() == null) {
                    return true;
                }
                return input.m_41783_().m_128451_("EnchantingId") != output.m_41783_().m_128451_("EnchantingId");
            }

            public boolean m_5857_(ItemStack pStack) {
                return super.m_5857_(pStack) && !ResearcherEnchantmentMenu.this.mayPickup;
            }

            public boolean m_8010_(Player pPlayer) {
                return super.m_8010_(pPlayer) && !ResearcherEnchantmentMenu.this.mayPickup;
            }
        });
        this.m_38897_(new Slot((Container)this.itemOutput, 0, 147, 114){

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
            }

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            public boolean m_8010_(Player pPlayer) {
                return super.m_8010_(pPlayer) && ResearcherEnchantmentMenu.this.mayPickup;
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                super.m_142406_(pPlayer, pStack);
                pStack.m_41749_("EnchantingId");
                ResearcherEnchantmentMenu.this.mayPickup = false;
            }
        });
    }

    private void addPlayerInventorySlots(Inventory inv) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)inv, l + i * 9 + 9, 8 + l * 18, 145 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 203));
        }
    }

    private void previewEnchantmentsOnItem(boolean clear) {
        ItemStack stack;
        if (clear) {
            this.itemOutput.m_6211_();
            this.itemOutput.m_6836_(0, this.itemInput.m_8020_(0).m_41777_());
            EnchantmentHelper.m_44865_(Map.of(), (ItemStack)this.itemOutput.m_8020_(0));
        }
        if ((stack = this.itemOutput.m_8020_(0)).m_41619_()) {
            return;
        }
        Map<Enchantment, Integer> map = ResearcherSkill.getSelectedEnchantments((LivingEntity)this.player, this.skill);
        if (map.isEmpty()) {
            return;
        }
        EnchantmentHelper.m_44865_(map, (ItemStack)stack);
        this.m_182423_();
    }

    public void editSelection(int id, int level) {
        if (this.mayPickup) {
            return;
        }
        Map<Enchantment, Integer> mapAll = ResearcherSkill.getAllEnchantments((LivingEntity)this.player, this.skill);
        if (mapAll.isEmpty() || id >= mapAll.entrySet().size()) {
            return;
        }
        Enchantment enchantment = (Enchantment)mapAll.keySet().stream().toList().get(id);
        if (enchantment instanceof EngravingEnchantment && this.itemOutput.m_8020_(0).m_41720_() instanceof EnchantedBookItem) {
            return;
        }
        int maxEnchantLevel = Math.min(this.getMaxStoredLevel(enchantment), ResearcherEnchantmentMenu.getMaxEnchantLevel(enchantment, this.player));
        if (level > maxEnchantLevel) {
            level = maxEnchantLevel;
        }
        int maxLevel = mapAll.values().stream().toList().get(id);
        Map<Enchantment, Integer> map = ResearcherSkill.getSelectedEnchantments((LivingEntity)this.player, this.skill);
        if (level == 0 && map.containsKey(enchantment)) {
            ResearcherSkill.setSelectedEnchantment((LivingEntity)this.player, enchantment, 0, this.skill);
            this.previewEnchantmentsOnItem(true);
        } else if (map.containsKey(enchantment)) {
            ResearcherSkill.setSelectedEnchantment((LivingEntity)this.player, enchantment, level, this.skill);
            this.previewEnchantmentsOnItem(true);
        } else {
            ResearcherSkill.setSelectedEnchantment((LivingEntity)this.player, enchantment, maxLevel, this.skill);
            this.previewEnchantmentsOnItem(false);
        }
        this.m_182423_();
    }

    public int getMaxStoredLevel(Enchantment enchantment) {
        Map<Enchantment, Integer> map = ResearcherSkill.getAllEnchantments((LivingEntity)this.player, this.skill);
        if (!map.containsKey(enchantment)) {
            return 0;
        }
        return map.get(enchantment);
    }

    public void handleFinalizeEnchantment() {
        ItemStack stack = this.itemInput.m_8020_(0).m_41777_();
        if (stack.m_41619_()) {
            ResearcherSkill.addSelectedEnchantments((LivingEntity)this.player, Map.of(), true, this.skill);
            return;
        }
        int cost = this.getExperienceCost();
        if (ResearcherEnchantmentMenu.getTotalXp(this.player) >= (long)cost) {
            if (cost > 0) {
                this.player.m_6756_(-cost);
            }
        } else {
            return;
        }
        this.mayPickup = true;
        Map<Enchantment, Integer> selected = ResearcherSkill.getSelectedEnchantments((LivingEntity)this.player, this.skill);
        EnchantmentHelper.m_44865_(selected, (ItemStack)stack);
        this.itemInput.m_6211_();
        this.itemOutput.m_6836_(0, stack);
        this.m_182423_();
        ResearcherSkill.addSelectedEnchantments((LivingEntity)this.player, Map.of(), true, this.skill);
        if (this.oldEnchantments.size() >= selected.size()) {
            return;
        }
        this.addSkillMastery();
    }

    public int getExperienceCost() {
        int cost = 0;
        if (this.player.m_7500_()) {
            return cost;
        }
        for (Map.Entry<Enchantment, Integer> entry : ResearcherSkill.getNewEnchantments((LivingEntity)this.player, this.skill).entrySet()) {
            cost += entry.getKey().m_6183_(entry.getValue().intValue());
        }
        return cost;
    }

    public static long getTotalXp(Player player) {
        long xp = player.f_36079_;
        for (int i = 0; i < player.f_36078_; ++i) {
            if (i >= 30) {
                xp += 112L + (long)(i - 30) * 9L;
                continue;
            }
            xp += i >= 15 ? (long)(37 + (i - 15) * 5) : (long)(7 + i * 2);
        }
        return xp;
    }

    public static int getMaxEnchantLevel(Enchantment enchantment, Player player) {
        if (player.m_7500_()) {
            return 255;
        }
        ResourceLocation location = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (location != null) {
            if (((List)TensuraConfig.INSTANCE.enchantmentsConfig.researcherBlacklist.get()).contains(location.toString())) {
                return 0;
            }
            if (((List)TensuraConfig.INSTANCE.enchantmentsConfig.researcherExceedingMaxBlacklist.get()).contains(location.toString())) {
                return enchantment.m_6586_();
            }
        }
        return enchantment.m_6586_() + (Integer)TensuraConfig.INSTANCE.enchantmentsConfig.maxResearcherBonus.get();
    }

    private void addSkillMastery() {
        Optional optional = SkillAPI.getSkillsFrom((Entity)this.player).getSkill(this.getSkill());
        if (optional.isPresent()) {
            ((ManasSkillInstance)optional.get()).addMasteryPoint((LivingEntity)this.player);
            ((ManasSkillInstance)optional.get()).markDirty();
            SkillAPI.getSkillsFrom((Entity)this.player).syncChanges();
        }
    }

    public void m_6877_(Player pPlayer) {
        this.itemInput.m_8020_(0).m_41749_("EnchantingId");
        this.itemOutput.m_8020_(0).m_41749_("EnchantingId");
        if (this.itemInput.m_7983_() && !this.itemOutput.m_7983_()) {
            this.m_150411_(pPlayer, (Container)this.itemOutput);
        } else {
            this.m_150411_(pPlayer, (Container)this.itemInput);
        }
        this.m_150411_(pPlayer, (Container)this.bookInput);
        super.m_6877_(pPlayer);
    }

    public boolean m_6875_(Player player) {
        return this.check();
    }

    public boolean check() {
        return this.player.m_6084_();
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack copy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            stack.m_41749_("EnchantingId");
            copy = stack.m_41777_();
            if (pIndex >= 0 && pIndex < 36 ? !this.m_38903_(stack, 36, 39, false) && (pIndex < 27 ? !this.m_38903_(stack, 27, 36, false) : !this.m_38903_(stack, 0, 27, false)) : !this.m_38903_(stack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == copy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, stack);
        }
        return copy;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ContainerLevelAccess getAccess() {
        return this.access;
    }

    public ManasSkill getSkill() {
        return this.skill;
    }

    public SimpleContainer getBookInput() {
        return this.bookInput;
    }

    public SimpleContainer getItemInput() {
        return this.itemInput;
    }

    public SimpleContainer getItemOutput() {
        return this.itemOutput;
    }
}

