/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.menu;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.menu.TensuraMenuHelper;
import com.github.manasmods.tensura.registry.menu.TensuraMenuTypes;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class DegenerateEnchantmentMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int INVENTORY_ROW_COUNT = 3;
    private static final int INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private final Player player;
    private final ResultContainer anvilResultSlot = new ResultContainer();
    public final ResultContainer disenchanterItemOutput = new ResultContainer();
    public final ResultContainer disenchanterBookOutput = new ResultContainer();
    private final Container anvilInputSlots = new SimpleContainer(2);
    public final Container disenchanterInputSlots = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            DegenerateEnchantmentMenu.this.m_6199_((Container)this);
            DegenerateEnchantmentMenu.this.slotUpdateListener.run();
        }
    };
    private final ContainerLevelAccess access;
    private int xp;
    Runnable slotUpdateListener = () -> {};

    public DegenerateEnchantmentMenu(int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        this(pContainerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public DegenerateEnchantmentMenu(int pContainerId, Inventory inventory, ContainerLevelAccess access) {
        super((MenuType)TensuraMenuTypes.DEGENERATE_ENCHANTMENT_MENU.get(), pContainerId);
        this.access = access;
        this.player = inventory.f_35978_;
        this.addPlayerInventorySlots(inventory);
        this.addGrindstoneSlots();
        this.addAnvilSlots();
    }

    public void createResult() {
        ItemStack inputItem = this.anvilInputSlots.m_8020_(0);
        if (inputItem.m_41619_()) {
            this.anvilResultSlot.m_6836_(0, ItemStack.f_41583_);
        } else {
            ItemStack copyInput = inputItem.m_41777_();
            ItemStack inputBook = this.anvilInputSlots.m_8020_(1);
            Map map = EnchantmentHelper.m_44831_((ItemStack)copyInput);
            if (!inputBook.m_41619_()) {
                boolean shouldEnchant;
                boolean bl = shouldEnchant = inputBook.m_41720_() == Items.f_42690_ && !EnchantedBookItem.m_41163_((ItemStack)inputBook).isEmpty();
                if (copyInput.m_41763_() && copyInput.m_41720_().m_6832_(inputItem, inputBook)) {
                    int repairDamage = Math.min(copyInput.m_41773_(), copyInput.m_41776_() / 4);
                    if (repairDamage <= 0) {
                        this.anvilResultSlot.m_6836_(0, ItemStack.f_41583_);
                        return;
                    }
                    int repairedDamage = copyInput.m_41773_() - repairDamage;
                    copyInput.m_41721_(repairedDamage);
                } else {
                    if (!(shouldEnchant || copyInput.m_150930_(inputBook.m_41720_()) && copyInput.m_41763_())) {
                        this.anvilResultSlot.m_6836_(0, ItemStack.f_41583_);
                        return;
                    }
                    if (copyInput.m_41763_() && !shouldEnchant) {
                        int repairDamage = inputItem.m_41776_() - inputItem.m_41773_();
                        int inputCount = inputBook.m_41776_() - inputBook.m_41773_();
                        int repairedDamage = inputCount + copyInput.m_41776_() * 12 / 100;
                        int newDurability = copyInput.m_41776_() - (repairDamage + repairedDamage);
                        if (newDurability < 0) {
                            newDurability = 0;
                        }
                        if (newDurability < copyInput.m_41773_()) {
                            copyInput.m_41721_(newDurability);
                        }
                    }
                    Map bookEnchantments = EnchantmentHelper.m_44831_((ItemStack)inputBook);
                    boolean doneEnchanted = false;
                    boolean stopEnchant = false;
                    Iterator iterator = bookEnchantments.keySet().iterator();
                    while (true) {
                        int bookLevel;
                        if (!iterator.hasNext()) {
                            if (!stopEnchant || doneEnchanted) break;
                            this.anvilResultSlot.m_6836_(0, ItemStack.f_41583_);
                            return;
                        }
                        Enchantment bookEnchant = (Enchantment)iterator.next();
                        if (bookEnchant == null) continue;
                        int itemLevel = map.getOrDefault(bookEnchant, 0);
                        bookLevel = itemLevel == (bookLevel = ((Integer)bookEnchantments.get(bookEnchant)).intValue()) ? bookLevel + 1 : Math.max(bookLevel, itemLevel);
                        boolean canEnchant = bookEnchant.m_6081_(inputItem);
                        if (inputItem.m_150930_(Items.f_42690_) || inputItem.m_150930_(Items.f_42398_)) {
                            canEnchant = true;
                        }
                        if (!canEnchant) {
                            stopEnchant = true;
                            continue;
                        }
                        doneEnchanted = true;
                        int maxLevel = bookEnchant.m_6586_();
                        if (this.canExceedMax(bookEnchant, copyInput)) {
                            maxLevel += 2;
                        }
                        if (bookLevel > maxLevel) {
                            bookLevel = maxLevel;
                        }
                        map.put(bookEnchant, bookLevel);
                    }
                }
                if (shouldEnchant && !copyInput.isBookEnchantable(inputBook)) {
                    copyInput = ItemStack.f_41583_;
                }
                if (!copyInput.m_41619_()) {
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)copyInput);
                }
                this.anvilResultSlot.m_6836_(0, copyInput);
                this.m_38946_();
            } else {
                this.anvilResultSlot.m_6836_(0, ItemStack.f_41583_);
            }
        }
    }

    public Map<Enchantment, Integer> getInputEnchantments() {
        return EnchantmentHelper.m_44831_((ItemStack)this.disenchanterInputSlots.m_8020_(0)).entrySet().stream().filter(entry -> !(entry.getKey() instanceof EngravingEnchantment)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void removeEnchantment(Enchantment enchantment, int level) {
        ItemStack outputStack = this.disenchanterInputSlots.m_8020_(0).m_41777_();
        Map map = EnchantmentHelper.m_44831_((ItemStack)outputStack);
        outputStack.m_41749_("Enchantments");
        outputStack.m_41749_("StoredEnchantments");
        map.remove(enchantment);
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)outputStack);
        ItemStack outputBook = this.disenchanterInputSlots.m_8020_(1).m_41777_();
        if (this.disenchanterBookOutput.m_8020_(0).m_41619_()) {
            if (outputBook.m_41619_()) {
                this.xp += enchantment.m_6183_(level) + this.player.m_217043_().m_216339_(0, enchantment.m_6175_(level) - enchantment.m_6183_(level));
            } else {
                if (outputBook.m_150930_(Items.f_42517_)) {
                    outputBook = new ItemStack((ItemLike)Items.f_42690_);
                }
                EnchantedBookItem.m_41153_((ItemStack)outputBook, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
                this.disenchanterBookOutput.m_6836_(0, outputBook);
            }
            this.disenchanterInputSlots.m_8020_(1).m_41774_(1);
        } else {
            outputBook = this.disenchanterBookOutput.m_8020_(0).m_41777_();
            EnchantedBookItem.m_41153_((ItemStack)outputBook, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
            this.disenchanterBookOutput.m_6836_(0, outputBook);
        }
        if (outputStack.m_150930_(Items.f_42690_) && map.isEmpty()) {
            outputStack = new ItemStack((ItemLike)Items.f_42517_);
        }
        this.disenchanterItemOutput.m_6836_(0, outputStack.m_41777_());
        if (this.xp > 0) {
            this.player.m_6756_(this.xp);
            this.player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.xp = 0;
        }
        this.disenchanterInputSlots.m_8020_(0).m_41774_(1);
        this.m_38946_();
    }

    private void addPlayerInventorySlots(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 25 + l * 18, 117 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 25 + i * 18, 175));
        }
    }

    private void addAnvilSlots() {
        this.m_38897_(new Slot((Container)this.anvilResultSlot, 0, 175, 30){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                super.m_142406_(pPlayer, pStack);
                pPlayer.m_216990_(SoundEvents.f_11887_);
                DegenerateEnchantmentMenu.this.anvilInputSlots.m_8020_(0).m_41774_(1);
                DegenerateEnchantmentMenu.this.anvilInputSlots.m_8020_(1).m_41774_(1);
            }
        });
        this.m_38897_(new Slot(this.anvilInputSlots, 0, 69, 30){

            public int m_6641_() {
                return 1;
            }

            public void m_5852_(ItemStack pStack) {
                super.m_5852_(pStack);
                if (!DegenerateEnchantmentMenu.this.anvilInputSlots.m_8020_(1).m_41619_()) {
                    DegenerateEnchantmentMenu.this.createResult();
                }
            }
        });
        this.m_38897_(new Slot(this.anvilInputSlots, 1, 118, 30){

            public void m_5852_(ItemStack pStack) {
                super.m_5852_(pStack);
                if (!DegenerateEnchantmentMenu.this.anvilInputSlots.m_8020_(0).m_41619_()) {
                    DegenerateEnchantmentMenu.this.createResult();
                }
            }
        });
    }

    private void addGrindstoneSlots() {
        this.m_38897_(new Slot((Container)this.disenchanterItemOutput, 0, 175, 65){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }
        });
        this.m_38897_(new Slot((Container)this.disenchanterBookOutput, 0, 175, 83){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }
        });
        this.m_38897_(new Slot(this.disenchanterInputSlots, 0, 19, 65){

            public int m_6641_() {
                return 1;
            }

            public boolean m_5857_(ItemStack pStack) {
                return DegenerateEnchantmentMenu.this.disenchanterItemOutput.m_7983_();
            }
        });
        this.m_38897_(new Slot(this.disenchanterInputSlots, 1, 19, 83){

            public boolean m_5857_(ItemStack pStack) {
                return pStack.m_150930_(Items.f_42517_) || pStack.m_150930_(Items.f_42690_);
            }
        });
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean check() {
        return true;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public boolean canExceedMax(Enchantment enchantment, ItemStack stack) {
        if (enchantment instanceof EngravingEnchantment) {
            return false;
        }
        if (enchantment.m_6586_() > 1) {
            return true;
        }
        if (enchantment.equals(Enchantments.f_44959_)) {
            return !(stack.m_41720_() instanceof CrossbowItem);
        }
        if (enchantment.equals(Enchantments.f_44971_)) {
            return false;
        }
        if (enchantment.equals(Enchantments.f_44958_)) {
            return false;
        }
        if (enchantment.equals(Enchantments.f_44975_)) {
            return false;
        }
        if (enchantment.equals(Enchantments.f_44963_)) {
            return false;
        }
        if (enchantment.equals(Enchantments.f_44990_)) {
            return false;
        }
        if (enchantment.equals(Enchantments.f_44952_)) {
            return false;
        }
        if (enchantment.equals(Enchantments.f_44962_)) {
            return false;
        }
        return !enchantment.equals(Enchantments.f_44985_);
    }

    public void m_6877_(Player pPlayer) {
        this.access.m_39292_((level, pos) -> {
            this.m_150411_(pPlayer, this.anvilInputSlots);
            this.m_150411_(pPlayer, this.disenchanterInputSlots);
            this.m_150411_(pPlayer, (Container)this.disenchanterItemOutput);
            this.m_150411_(pPlayer, (Container)this.disenchanterBookOutput);
        });
        super.m_6877_(pPlayer);
    }

    public ItemStack m_7648_(Player pPlayer, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyStack = sourceStack.m_41777_();
        if (index < 27) {
            if (!this.m_38903_(sourceStack, 27, 36, false)) {
                return ItemStack.f_41583_;
            }
            return TensuraMenuHelper.quickMoveStack(pPlayer, sourceStack, sourceSlot, copyStack);
        }
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            return TensuraMenuHelper.quickMoveStack(pPlayer, sourceStack, sourceSlot, copyStack);
        }
        if (!sourceSlot.m_8010_(pPlayer)) {
            return ItemStack.f_41583_;
        }
        if (!this.m_38903_(sourceStack, 0, 36, false)) {
            return ItemStack.f_41583_;
        }
        sourceSlot.m_40234_(sourceStack, copyStack);
        return TensuraMenuHelper.quickMoveStack(pPlayer, sourceStack, sourceSlot, copyStack);
    }

    public ContainerLevelAccess getAccess() {
        return this.access;
    }
}

