/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.templates.custom;

import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.item.templates.custom.TensuraSword;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwoHandedSword
extends TensuraSword {
    private final int oneHandedAttackDamageModifier;
    private final float oneHandedAttackSpeedModifier;
    private final double oneHandedCritChance;
    private final double oneHandedCritDamageMultiplier;
    private double oneHandedSweepChance;

    public TwoHandedSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        this(pTier, pAttackDamageModifier, pAttackSpeedModifier, critChance, critDamageMultiplier, pAttackDamageModifier, sweepChance, oneHandedSweepChance, pProperties);
    }

    public TwoHandedSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, int oneHandedAttackDamageModifier, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        this(pTier, pAttackDamageModifier, pAttackSpeedModifier, critChance, critDamageMultiplier, oneHandedAttackDamageModifier, pAttackSpeedModifier, sweepChance, oneHandedSweepChance, pProperties);
    }

    public TwoHandedSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, int oneHandedAttackDamageModifier, float oneHandedAttackSpeedModifier, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        this(pTier, pAttackDamageModifier, pAttackSpeedModifier, critChance, critDamageMultiplier, oneHandedAttackDamageModifier, oneHandedAttackSpeedModifier, critChance, sweepChance, oneHandedSweepChance, pProperties);
    }

    public TwoHandedSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, int oneHandedAttackDamageModifier, float oneHandedAttackSpeedModifier, double oneHandedCritChance, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        this(pTier, pAttackDamageModifier, pAttackSpeedModifier, critChance, critDamageMultiplier, oneHandedAttackDamageModifier, oneHandedAttackSpeedModifier, oneHandedCritChance, critDamageMultiplier, sweepChance, oneHandedSweepChance, pProperties);
    }

    public TwoHandedSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, int oneHandedAttackDamageModifier, float oneHandedAttackSpeedModifier, double oneHandedCritChance, double oneHandedCritDamageMultiplier, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, critChance, critDamageMultiplier, sweepChance, pProperties);
        this.oneHandedAttackDamageModifier = (int)(this.m_43314_().m_6631_() + (float)oneHandedAttackDamageModifier);
        this.oneHandedAttackSpeedModifier = 4.0f + oneHandedAttackSpeedModifier;
        this.oneHandedCritChance = oneHandedCritChance;
        this.oneHandedCritDamageMultiplier = oneHandedCritDamageMultiplier;
        this.oneHandedSweepChance = oneHandedSweepChance;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        if (TwoHandedSword.isTwoHanded(stack)) {
            return super.getAttributeModifiers(slot, stack);
        }
        return ImmutableMultimap.builder().put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.oneHandedAttackDamageModifier, AttributeModifier.Operation.ADDITION)).put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.oneHandedAttackSpeedModifier, AttributeModifier.Operation.ADDITION)).put((Object)((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()), (Object)new AttributeModifier(BASE_CRIT_CHANCE_UUID, "Weapon modifier", this.oneHandedCritChance, AttributeModifier.Operation.ADDITION)).put((Object)((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()), (Object)new AttributeModifier(BASE_CRIT_MULTIPLIER_UUID, "Weapon modifier", this.oneHandedCritDamageMultiplier, AttributeModifier.Operation.ADDITION)).build();
    }

    public ItemStack m_7968_() {
        ItemStack defaultStack = super.m_7968_();
        TwoHandedSword.setTwoHandedTag(defaultStack, true);
        return defaultStack;
    }

    public static void setTwoHandedTag(ItemStack stack, boolean value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("isTwoHanded", value);
        stack.m_41751_(tag);
    }

    public static boolean isTwoHanded(ItemStack stack) {
        if (!(stack.m_41720_() instanceof TwoHandedSword)) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        if (!tag.m_128441_("isTwoHanded")) {
            return false;
        }
        return tag.m_128471_("isTwoHanded");
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.long_sword.tooltip"));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public int getOneHandedAttackDamageModifier() {
        return this.oneHandedAttackDamageModifier;
    }

    public float getOneHandedAttackSpeedModifier() {
        return this.oneHandedAttackSpeedModifier;
    }

    public double getOneHandedCritChance() {
        return this.oneHandedCritChance;
    }

    public double getOneHandedCritDamageMultiplier() {
        return this.oneHandedCritDamageMultiplier;
    }

    public double getOneHandedSweepChance() {
        return this.oneHandedSweepChance;
    }
}

