/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.templates.custom;

import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import org.jetbrains.annotations.NotNull;

public class TensuraSword
extends SwordItem {
    protected static final UUID BASE_CRIT_CHANCE_UUID = UUID.fromString("6595a9a4-a3b0-11ed-a8fc-0242ac120002");
    protected static final UUID BASE_CRIT_MULTIPLIER_UUID = UUID.fromString("e731da6e-a3b0-11ed-a8fc-0242ac120002");
    protected static final UUID BASE_SWEEP_CHANCE_UUID = UUID.fromString("a20fa56e-3bf0-4ab7-8042-2eec78563b80");
    private final double critChance;
    private final double critDamageMultiplier;
    private double sweepChance;

    public TensuraSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        this(pTier, pAttackDamageModifier, pAttackSpeedModifier, 0.0, 0.0, 0.0, pProperties);
    }

    public TensuraSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, Item.Properties pProperties) {
        this(pTier, pAttackDamageModifier, pAttackSpeedModifier, critChance, critDamageMultiplier, 0.0, pProperties);
    }

    public TensuraSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, double sweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        this.critChance = critChance;
        this.critDamageMultiplier = critDamageMultiplier;
        this.sweepChance = sweepChance;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        if (pEquipmentSlot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.builder().putAll(super.m_7167_(pEquipmentSlot)).put((Object)((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()), (Object)new AttributeModifier(BASE_CRIT_CHANCE_UUID, "Weapon modifier", this.critChance, AttributeModifier.Operation.ADDITION)).put((Object)((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()), (Object)new AttributeModifier(BASE_CRIT_MULTIPLIER_UUID, "Weapon modifier", this.critDamageMultiplier, AttributeModifier.Operation.ADDITION)).put((Object)((Attribute)ManasCoreAttributes.SWEEP_CHANCE.get()), (Object)new AttributeModifier(BASE_SWEEP_CHANCE_UUID, "Weapon modifier", this.sweepChance, AttributeModifier.Operation.ADDITION)).build();
    }

    public double getCritChance() {
        return this.critChance;
    }

    public double getCritDamageMultiplier() {
        return this.critDamageMultiplier;
    }

    public double getSweepChance() {
        return this.sweepChance;
    }
}

