/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.templates.custom;

import com.github.manasmods.tensura.api.item.dispensing.TensuraDispenseBehaviors;
import com.github.manasmods.tensura.entity.projectile.SpearProjectile;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class SimpleSpearItem
extends TwoHandedLongSword {
    private static final List<Enchantment> enchantmentList = ImmutableSet.of((Object)Enchantments.f_44961_, (Object)Enchantments.f_44956_, (Object)Enchantments.f_44955_).asList();

    public SimpleSpearItem(Tier pTier, Item.Properties properties) {
        super(pTier, 3, -2.6f, 2.0, 0.0, 0.0, 2, -3.0f, 0.0, 0.0, properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)TensuraDispenseBehaviors.DISPENSE_SPEAR_BEHAVIOR);
    }

    public SimpleSpearItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, int oneHandedAttackDamageModifier, float oneHandedAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, 2.0, critChance, critDamageMultiplier, oneHandedAttackDamageModifier, oneHandedAttackSpeedModifier, pProperties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)TensuraDispenseBehaviors.DISPENSE_SPEAR_BEHAVIOR);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.f_44983_)) {
            return false;
        }
        return enchantmentList.contains(enchantment) || enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ToolAction toolAction) {
        if (ToolActions.SWORD_SWEEP.equals(toolAction)) {
            return false;
        }
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 36000;
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            int i = this.m_8105_(pStack) - pTimeLeft;
            if (i >= 10) {
                if (!pLevel.f_46443_) {
                    pStack.m_41622_(10, (LivingEntity)player, pPlayer -> pPlayer.m_21190_(pEntityLiving.m_7655_()));
                    boolean left = pEntityLiving.m_7655_() == InteractionHand.OFF_HAND && pEntityLiving.m_5737_() == HumanoidArm.RIGHT || pEntityLiving.m_7655_() == InteractionHand.MAIN_HAND && pEntityLiving.m_5737_() == HumanoidArm.LEFT;
                    SpearProjectile spear = new SpearProjectile(pLevel, (LivingEntity)player, pStack, !left);
                    spear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
                    if (player.m_150110_().f_35937_) {
                        spear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    pLevel.m_7967_((Entity)spear);
                    pLevel.m_6269_(null, (Entity)spear, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150109_().m_36057_(pStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 10) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }
}

