/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.templates;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class SimpleCrossbowItem
extends CrossbowItem {
    protected final int chargeTicks;
    protected final float inaccuracy;
    protected final float arrowPower;
    protected final float fireworkPower;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public SimpleCrossbowItem(Item.Properties pProperties, int pChargeTicks, float arrowPower, float fireworkPower, float pInaccuracy) {
        super(pProperties);
        this.arrowPower = arrowPower;
        this.fireworkPower = fireworkPower;
        this.inaccuracy = pInaccuracy;
        this.chargeTicks = pChargeTicks;
    }

    public int m_8105_(ItemStack pStack) {
        int i = pStack.getEnchantmentLevel(Enchantments.f_44960_);
        return i == 0 ? this.chargeTicks + 3 : this.chargeTicks - 5 * i + 3;
    }

    public float m_40945_(ItemStack pCrossbowStack) {
        return SimpleCrossbowItem.m_40871_((ItemStack)pCrossbowStack, (Item)Items.f_42688_) ? this.fireworkPower : this.arrowPower;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (SimpleCrossbowItem.m_40932_((ItemStack)itemstack)) {
            SimpleCrossbowItem.m_40887_((Level)pLevel, (LivingEntity)pPlayer, (InteractionHand)pHand, (ItemStack)itemstack, (float)this.m_40945_(itemstack), (float)this.inaccuracy);
            SimpleCrossbowItem.m_40884_((ItemStack)itemstack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!pPlayer.m_6298_(itemstack).m_41619_()) {
            if (!SimpleCrossbowItem.m_40932_((ItemStack)itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                pPlayer.m_6672_(pHand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pCount) {
        if (!pLevel.f_46443_) {
            int i = pStack.getEnchantmentLevel(Enchantments.f_44960_);
            SoundEvent soundEvent = i == 0 ? SoundEvents.f_11842_ : null;
            SoundEvent startSound = switch (i) {
                case 1 -> SoundEvents.f_11844_;
                case 2 -> SoundEvents.f_11845_;
                case 3 -> SoundEvents.f_11846_;
                default -> SoundEvents.f_11843_;
            };
            float f = (float)(pStack.m_41779_() - pCount) / (float)SimpleCrossbowItem.m_40939_((ItemStack)pStack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                pLevel.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), startSound, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                pLevel.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }
}

