/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class SlimeBucketItem
extends MobBucketItem {
    public SlimeBucketItem(Item.Properties properties) {
        super(TensuraEntityTypes.SLIME, () -> Fluids.f_76191_, () -> SoundEvents.f_12387_, properties);
    }

    public void m_142131_(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawnSlime((ServerLevel)level, stack, pos);
            level.m_142346_((Entity)player, GameEvent.f_157810_, pos);
        }
    }

    private void spawnSlime(ServerLevel serverLevel, ItemStack stack, BlockPos pos) {
        EntityType type = this.getFishType();
        if (stack.m_41783_() != null && stack.m_41783_().m_128471_("MetalSlime")) {
            type = (EntityType)TensuraEntityTypes.METAL_SLIME.get();
        } else if (stack.m_41783_() != null && stack.m_41783_().m_128471_("Supermassive")) {
            type = (EntityType)TensuraEntityTypes.SUPERMASSIVE_SLIME.get();
        }
        Entity slime = type.m_20655_(serverLevel, stack.m_41783_(), stack.m_41788_() ? stack.m_41786_() : null, null, pos, MobSpawnType.BUCKET, true, false);
        if (slime instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)slime;
            bucketable.m_142278_(stack.m_41784_());
            bucketable.m_27497_(true);
            slime.m_20035_(pos, slime.m_146909_(), slime.m_146908_());
            serverLevel.m_47205_(slime);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)itemstack, (HitResult)(blockhitresult = SlimeBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos relative = blockpos.m_121945_(direction);
        if (level.m_7966_(player, blockpos) && player.m_36204_(relative, direction, itemstack)) {
            this.m_142131_(player, level, itemstack, relative);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)SlimeBucketItem.m_40699_((ItemStack)itemstack, (Player)player), (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }
}

