/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ShadowStorageItem
extends Item
implements DispensibleContainerItem {
    public ShadowStorageItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag tag = pStack.m_41783_();
        if (tag == null) {
            return;
        }
        pTooltipComponents.add((Component)Component.m_237115_((String)"tensura.attribute.existence_points.shortened_name").m_130946_(": " + tag.m_128459_("ShadowEP")).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tensura.vanilla_attribute.health.shortened_name").m_130946_(": " + tag.m_128459_("ShadowHP")).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tensura.attribute.spiritual_health.shortened_name").m_130946_(": " + tag.m_128459_("ShadowSHP")).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142131_(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawnShadow((ServerLevel)level, stack, pos);
            level.m_142346_((Entity)player, GameEvent.f_157810_, pos);
        }
    }

    public boolean m_142073_(@Nullable Player pPlayer, Level pLevel, BlockPos pPos, @Nullable BlockHitResult pResult) {
        return false;
    }

    private void spawnShadow(ServerLevel serverLevel, ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        ResourceLocation typeID = ResourceLocation.m_135820_((String)tag.m_128461_("EntityType"));
        EntityType type = (EntityType)Registry.f_122826_.m_7745_(typeID);
        Entity shadow = type.m_20655_(serverLevel, stack.m_41783_(), null, null, pos, MobSpawnType.BUCKET, true, false);
        if (shadow == null) {
            return;
        }
        shadow.m_20258_(tag.m_128469_("ShadowData"));
        shadow.m_20035_(pos, shadow.m_146909_(), shadow.m_146908_());
        serverLevel.m_47205_(shadow);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult blockhitresult = ShadowStorageItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos relative = blockpos.m_121945_(direction);
        if (level.m_7966_(player, blockpos) && player.m_36204_(relative, direction, itemstack)) {
            this.m_142131_(player, level, itemstack, relative);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)ItemStack.f_41583_, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }
}

